<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
        <div class="flex flex-col">
            <span class="font-semibold text-primary text-xl">Sub Boxes for "{{ $box->box_name }}"</span>
            <span><a href="{{route('dashboard')}}" class="font-semibold text-danger underline" >Home</a> <i class="fa fa-angle-right text-xs text-danger"></i> <a href="{{route('inventory.storage')}}" class="font-semibold text-success underline">Boxes</a> <i class="fa fa-angle-right text-xs text-success"></i> <span class="font-normal text-warning text-sm">Sub Boxes</span></span>
        </div>

        @can('create storage')
            @if($isBoxActive)
        <span wire:click="toggleShowAddNewSubBoxModel" class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
            <i class="fa fa-plus mr-2"></i>Add Sub Box
        </span>
            @endif
        @endcan
    </div>

    <div class="w-full overflow-x-auto p-4">
        @if($subBoxes->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($subBoxes as $subBox)
                    <div class="bg-white border-2 border-primary/15 rounded-lg shadow-sm hover:shadow-md transition-all duration-300 relative overflow-hidden group">
                        <!-- Sub-box indicator ribbon -->
                        <div class="absolute top-2 left-2 bg-primary/80 text-white px-2 py-1 rounded-r-md text-[10px] font-bold uppercase tracking-wide">
                            Sub-box
                        </div>



                        <!-- Edit/Delete buttons (more subtle than main boxes) -->
                        <div class="absolute top-2 right-2 flex gap-1 opacity-0 group-hover:opacity-100 transition-opacity">
                            @can('edit storage')
                                <button wire:click="loadSubBoxData({{ $subBox->id }})"
                                        class="text-primary/70 hover:text-primary transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-white border border-primary/20 hover:bg-primary/10"
                                        title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>
                            @endcan
                            @can('delete storage')
                                <button wire:click="deleteSubBox({{ $subBox->id }})"
                                        wire:confirm="Are you sure you want to delete this sub box?"
                                        class="text-danger/70 hover:text-danger transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-white border border-danger/20 hover:bg-danger/10"
                                        title="Delete">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            @endcan
                        </div>

                        <!-- Inner box design (smaller than main boxes) -->
                        <div class="p-4 pt-7">
                            <div class="mb-3 mt-2">
                                <h4 class="font-bold text-primary text-md truncate">{{ $subBox->sub_box_name }}</h4>
                                <div class="text-xs text-gray-500 mt-1">ID: {{ $subBox->id }}</div>
                            </div>

                            <!-- Storage details -->
                            <div class="space-y-2 text-sm mb-3">
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-cube text-primary/70"></i>
                                    <span>Slots: {{ $subBox->items_slots_count ?? '0' }}</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-shopping-cart text-primary/70"></i>
                                    <span>
    Items: {{
        $subBox->itemsSlots?->flatMap(fn($slot) =>
            $slot->items ?? collect()
        )?->count() ?? '0'
    }}
</span>

                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-file text-primary/70"></i>
                                    <span>
    Files: {{
        $subBox->itemsSlots?->flatMap(fn($slot) =>
            $slot->slotFiles ?? collect()
        )?->count() ?? '0'
    }}
</span>

                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-tag text-primary/70"></i>
                                    <button wire:click="toggleStatus({{ $subBox->id }})"
                                            class="px-2 py-0.5 rounded-full text-xs font-medium cursor-pointer transition-colors {{ $subBox->status ? 'bg-success/20 text-success hover:bg-success/30' : 'bg-danger/20 text-danger hover:bg-danger/30' }}">
                                        {{ $subBox->status ? 'Active' : 'Inactive' }}
                                    </button>
                                </div>
                            </div>

                            <!-- Bottom label -->
                            <div class="border-t border-dashed border-gray-200 pt-2">
                                <div class="flex justify-between items-center text-xs text-gray-500">
                                    <div class="text-primary">
                                        <i class="far fa-calendar-alt mr-1 text-danger"></i>
                                        {{ $subBox->created_at->format('M d, Y') }}
                                    </div>
                                    @can('view storage')
                                        <a href="{{route('inventory.items-slots', ['sub_box_id' => $subBox->id])}}" class="text-primary/70 hover:text-primary text-xs flex items-center">
                                            View Slots <i class="fas fa-chevron-right ml-1 text-[10px]"></i>
                                        </a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-300">
                <div class="text-primary/40 mb-4">
                    <i class="fas fa-boxes text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">No Sub-boxes Found</h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    "{{ $box->box_name }}" doesn't contain any sub-boxes yet.
                </p>
                @can('create storage')
                    <button wire:click="createNewSubBox"
                            class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors text-sm">
                        <i class="fas fa-plus mr-2"></i> Create Sub-box
                    </button>
                @endcan
            </div>
        @endif
    </div>

    @if($showAddNewSubBoxModel)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">{{ $isEditing ? 'Edit Sub Box' : 'Add New Sub Box' }}</h3>
                <form wire:submit="saveSubBox">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Sub box name <span class="text-danger">*</span></label>
                            <input type="text" wire:model="sub_box_name" placeholder="Enter sub box name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('sub_box_name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="closeAddNewSubBoxModel"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">Back</button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveSubBox">{{ $isEditing ? 'Update' : 'Save' }}</span>
                            <span wire:loading wire:target="saveSubBox">{{ $isEditing ? 'Updating...' : 'Saving...' }} <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>
