<div
    class=" w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Boxes</span>
        <div class="flex items-center gap-2  justify-end">
            <div class="relative">
                <input type="text" wire:model.live.debounce.1000ms="search" placeholder="Search items & files..."
                       class="px-3 py-1.5 max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                        <i class="fa fa-times"></i>
                    </button>
                @else
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                @endif
            </div>
            @can('create storage')
                <span wire:click="toggleShowAddNewBoxModel"
                      class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Add Box
            </span>
            @endcan
        </div>
    </div>

    <div class="w-full overflow-x-auto p-4">
        <!-- Search Results Table -->
        @if(!empty($search) && strlen($search) >= 3)
            <div class="mb-6" wire:loading.class="opacity-50">
                <h3 class="text-lg font-semibold text-primary mb-3 flex items-center">
                    <i class="fas fa-search mr-2"></i> Search Results for "{{ $search }}"
                    <span class="ml-2 text-sm font-medium bg-primary/10 text-primary px-2 py-0.5 rounded-full">{{ count($searchResults) }}</span>
                </h3>

                @if(count($searchResults) > 0)
                    <div class="overflow-x-auto">
                        <table class="w-full border-[2px] border-secondary/40 border-collapse mt-4">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Type</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item Name</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Info</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">User</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item Path</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($searchResults as $index => $result)
                                    <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">{{ $index + 1 }}</td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                            @if($result['type'] === 'item')
                                                 <span class="px-2 py-1 text-xs font-medium rounded-full bg-success/10 text-success"> <i class="fa fa-box mr-2 text-xs"></i> Item</span>
                                            @else
                                                 <span class="px-2 py-1 text-xs font-medium rounded-full bg-primary/10 text-primary"><i class="fa fa-file mr-2 text-xs"></i> File</span>
                                            @endif
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><i class="fa fa-gift text-primary mr-1 text-xs"></i> {{ $result['name'] }}</td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap max-w-xl overflow-x-auto"><i class="fa fa-tag text-primary mr-1 text-xs"></i>{{ $result['info'] }}</td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><i class="fa fa-user text-primary mr-1 text-xs"></i>{{ $result['user'] }}</td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><i class="fa fa-route text-danger mr-1 text-xs"></i>{{ $result['path'] }}</td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                            <button wire:click="viewSearchResult('{{ $result['type'] }}', {{ $result['id'] }})"
                                                    class="text-primary hover:text-primary-dark transition-colors">
                                                <i class="fas fa-eye mr-1"></i> View
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="bg-gray-50 p-6 text-center rounded-lg border border-gray-200">
                        <div class="text-gray-400 mb-2">
                            <i class="fas fa-search fa-2x"></i>
                        </div>
                        <p class="text-gray-600">No results found for "{{ $search }}"</p>
                        <p class="text-gray-500 text-sm mt-1">Try a different search term or check your spelling</p>
                    </div>
                @endif
            </div>
        @endif

        <!-- Boxes Grid -->
        @if(empty($search) || strlen($search) < 3)
            @if($boxes->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6" wire:loading.class="opacity-50">
                    @foreach($boxes as $box)
                    <div
                        class="bg-white border-2 border-primary/20 rounded-lg shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 relative overflow-hidden">
                        <!-- Box label sticker effect -->
                        <div
                            class="absolute top-2 left-2 bg-primary/90 text-white px-3 py-1 rounded-r-md text-xs font-bold shadow-sm">
                            BOX #{{ $box->id }}
                        </div>
                            <button wire:click="generateQrCode({{ $box->id }})"
                                    class="absolute {{!$box->subBoxes->count()>0?'right-20':'right-10'}} top-2 text-secondary/80 hover:text-white transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-secondary/20 hover:bg-secondary"
                                    title="Generate QR Code">
                                <i class="fas fa-qrcode text-[11px]"></i>
                            </button>
                        @can('edit storage')
                            <button wire:click="loadBoxData({{ $box->id }})"
                                    class="absolute  {{!$box->subBoxes->count()>0?'right-10':'right-2'}}  top-2 text-primary/80 hover:text-white transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-primary/20 hover:bg-primary"
                                    title="Edit">
                                <i class="fas fa-edit text-[11px]"></i>
                            </button>
                        @endcan
                        @can('delete storage')

                            @if(!$box->subBoxes->count()>0)
                                <button wire:click="deleteBox({{ $box->id }})"
                                        wire:confirm="Are you sure you want to delete this box?"
                                        class="absolute right-2 top-2 text-red-600 hover:text-white transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-danger/20 hover:bg-danger"
                                        title="Delete">
                                    <i class="fas fa-trash text-[11px]"></i>
                                </button>
                            @endif
                        @endcan

                        <!-- Box tape effect at top -->
                        <div
                            class="absolute top-0 left-1/2 transform -translate-x-1/2 w-16 h-4 bg-yellow-100/80 border border-yellow-200 rounded-sm"></div>

                        <div class="p-5 pt-8">
                            <div class="flex justify-between items-start mb-3">
                                <div>
                                    <h4 class="font-bold text-primary text-lg truncate max-w-[180px]">{{ $box->box_name }}</h4>
                                </div>

                            </div>

                            <!-- Storage details with icons -->
                            <div class="space-y-2 text-sm mb-4">
                                @if($box->lab)
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-flask text-primary"></i>
                                        <span class="truncate">{{ $box->lab->lab_name }}</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-user-tie text-primary"></i>
                                        <span
                                            class="truncate text-xs">{{ $box->lab->principalInvestigator ? $box->lab->principalInvestigator->first_name . ' ' . $box->lab->principalInvestigator->last_name : 'No PI' }}</span>
                                    </div>
                                @endif
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-layer-group text-primary"></i>
                                    <span>Sub-boxes: {{ $box->sub_boxes_count ?? '0' }}</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-cube text-primary"></i>
                                    <span>
    Items: {{
        $box->subBoxes?->flatMap(fn($subBox) =>
            $subBox->itemsSlots?->flatMap(fn($slot) =>
                $slot->items ?? collect()
            ) ?? collect()
        )?->count() ?? '0'
    }}
</span>

                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-file text-primary"></i>
                                    <span>Files: {{ $box->total_files ?? '0' }}</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-tag text-primary"></i>
                                    <span wire:click="toggleStatus({{$box->id}})"
                                          class="px-2 py-0.5 rounded-full text-xs font-bold cursor-pointer  {{ $box->status ? 'bg-success/20 text-success' : 'bg-danger/20 text-danger' }}">
                                    {{ $box->status ? 'Active' : 'Inactive' }}
                            </span>
                                </div>
                            </div>

                            <!-- Box bottom details (like a shipping label) -->
                            <div class="border-t border-dashed border-gray-200 pt-3">
                                <div class="flex justify-between items-center text-xs text-gray-500">
                                    <div class="text-primary">
                                        <i class="far fa-calendar-alt mr-1 text-danger"></i>
                                        {{ $box->created_at->format('M d, Y') }}
                                    </div>
                                    @can('view storage')
                                        <a href="{{route('inventory.sub-boxes',['id'=>$box->id])}}"
                                           class="text-primary hover:text-primary-dark text-xs font-medium flex items-center">
                                            View Contents <i class="fas fa-chevron-right ml-1 text-xs"></i>
                                        </a>
                                    @endcan

                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                </div>
            @else
                <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                    <div class="text-gray-400 mb-4">
                        <i class="fas fa-box-open text-5xl"></i>
                    </div>
                    <h3 class="text-lg font-medium text-gray-600 mb-2">No Storage Boxes Found</h3>
                    <p class="text-gray-500 max-w-md mx-auto mb-4">You don't have any storage boxes yet. Create your first
                        box to start organizing your items.</p>
                    @can('create storage')
                        <button wire:click="toggleShowAddNewBoxModel"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                            <i class="fas fa-plus mr-2"></i> Create New Box
                        </button>
                    @endcan
                </div>
            @endif
        @endif
    </div>

    @if($showAddNewBoxModel)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">{{ $isEditing ? 'Edit Box' : 'Add New Box' }}</h3>
                <form wire:submit="saveBox">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Lab <span class="text-danger">*</span></label>
                            <select wire:model="lab_id"
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select Lab</option>
                                @foreach($availableLabs as $lab)
                                    <option value="{{ $lab['id'] }}">
                                        {{ $lab['name'] }} - {{ $lab['pi_name'] }} ({{ $lab['building'] }},
                                        Room {{ $lab['room'] }})
                                    </option>
                                @endforeach
                            </select>
                            @error('lab_id') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Box name <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model="box_name" placeholder="Enter box name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('box_name') <span class="text-red-500"><i
                                    class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="closeAddNewBoxModel"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Back
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveBox">{{ $isEditing ? 'Update' : 'Save' }}</span>
                            <span wire:loading wire:target="saveBox">{{ $isEditing ? 'Updating...' : 'Saving...' }} <i
                                    class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    @if($showQrCodeModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
                <!-- Modal Header -->
                <div class="flex justify-between items-center border-b px-6 py-4">
                    <h3 class="text-lg font-semibold">Storage Box QR Code</h3>
                    <button wire:click="$set('showQrCodeModal', false)" class="text-gray-500 hover:text-gray-700">
                        <i class="fa fa-times"></i>
                    </button>
                </div>

                <!-- Modal Content -->
                <div class="p-6">
                    <div class="flex flex-col items-center">
                        @if($qrCodeData)
                            <img src="{{ $qrCodeData }}" alt="QR Code" class="w-64 h-64">
                        @endif

                        <div class="text-center mt-4">
                            <h4 class="font-medium text-gray-900">{{ $selectedBox->box_name ?? '' }}</h4>
                            @if($selectedBox && $selectedBox->lab)
                                <p class="text-sm text-gray-600">{{ $selectedBox->lab->lab_name }}</p>
                            @endif
                        </div>

                        <!-- Printing section -->
                        <div class="mt-6 w-full">
                            <div class="flex items-center justify-center gap-2">
                                <input type="number" wire:model="qrCodeCount" min="1" max="100" placeholder="How many QR codes?"
                                       class="px-2 py-1 w-32 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <button wire:click="printQrCodes({{ $selectedBox->id ?? 0 }})"
                                        class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark transition">
                                    Print QR Codes
                                </button>
                            </div>
                            @error('qrCodeCount')
                            <p class="text-red-500 text-xs mt-1 text-center">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="border-t px-6 py-3 bg-gray-50 flex justify-end">
                    <button wire:click="$set('showQrCodeModal', false)"
                            class="px-4 py-2 bg-danger text-white rounded hover:bg-primary-dark transition">
                        Close
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>
