<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('info'))
        <div id="infoMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-info bg-blue-100 border-l-4 border-blue-500 text-blue-700 px-4 py-2 mb-4 pr-20">
            {{ session('info') }}
            <div onclick="document.getElementById('infoMessage').classList.add('hidden')"
                 class="cursor-pointer bg-blue-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Stock Management</span>
        <div class="flex items-center gap-2 justify-end">




            <span wire:click="toggleStockIntakeModal"
                  class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Stock Intake
            </span>
        </div>
    </div>

        <div class="w-full flex flex-col xl:flex-row justify-between gap-4 px-4">
            <div class="flex flex-col sm:flex-row gap-2">
                <button wire:click="exportTransactions"
                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportTransactions">
                        <i class="fa fa-file-excel mr-2"></i>Excel
                    </span>
                    <span wire:loading wire:target="exportTransactions">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>

                <button wire:click="exportTransactionsPdf"
                        class="text-sm bg-danger/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 text-white hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportTransactionsPdf">
                        <i class="fa fa-file-pdf mr-2"></i>PDF
                    </span>
                    <span wire:loading wire:target="exportTransactionsPdf">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>
            </div>
            <div class="flex flex-col sm:flex-row lg:flex-wrap xl:flex-nowrap gap-2">

                <select wire:model.live="itemFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Items</option>
                    @foreach($inventoryItems as $item)
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                    @endforeach
                </select>

                <select wire:model.live="supplierFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Suppliers</option>
                    @foreach($suppliers as $supplier)
                        <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                    @endforeach
                </select>

                <select wire:model.live="statusFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Status</option>
                    <option value="expired">Expired</option>
                    <option value="expiring_soon">Expiring Soon</option>
                    <option value="low_stock">Low Stock</option>
                    <option value="out_of_stock">Out of Stock</option>
                </select>

                <input type="date" wire:model.live="dateFrom" placeholder="From Date"
                       class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">

                <input type="date" wire:model.live="dateTo" placeholder="To Date"
                       class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">

{{--                <select wire:model.live="transactionTypeFilter"--}}
{{--                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">--}}
{{--                    <option value="">All Transactions</option>--}}
{{--                    <option value="in">Stock In</option>--}}
{{--                    <option value="out">Stock Out</option>--}}
{{--                </select>--}}
                <div class="relative">
                    <input type="text" wire:model.live.debounce.500ms="search" placeholder="Search batches..."
                           class="px-3 py-1.5 max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    @if($search)
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                            <i class="fa fa-times"></i>
                        </button>
                    @else
                        <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                    @endif
                </div>
            </div>
        </div>

    <div class="w-full overflow-x-auto p-4 pt-0">
        @if($stockBatches->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full border-[2px] border-secondary/40 border-collapse"
                       wire:loading.class="opacity-25">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Batch Number</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Variant</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Supplier</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Quantity</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Expiry Date</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Status</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stockBatches as $index => $batch)
                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    {{ ($stockBatches->currentPage() - 1) * $stockBatches->perPage() + $index + 1 }}
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="flex items-center">
                                        <i class="fa fa-barcode text-primary mr-2"></i>
                                        <div>
                                            <div class="font-semibold">{{ $batch->batch_number }}</div>
                                            <div class="text-xs text-gray-500">
                                                Received: {{ $batch->received_date->format('M d, Y') }}
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    @if($batch->batchItems->count() > 0)
                                        <div class="space-y-2">
                                            @foreach($batch->batchItems->take(3) as $batchItem)
                                                <div class="flex items-start">
                                                    <i class="fa {{ $batchItem->inventoryItem->item_type === 'chemical' ? 'fa-flask' : 'fa-box' }} text-primary mr-2 text-xs mt-1"></i>
                                                    <div>
                                                        <div class="font-semibold text-sm">{{ $batchItem->inventoryItem->name }}</div>
                                                        <span class="px-2 py-1 text-xs font-medium rounded-full
                                                            {{ $batchItem->inventoryItem->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800' }}">
                                                            {{ ucfirst($batchItem->inventoryItem->item_type) }}
                                                        </span>
                                                    </div>
                                                </div>
                                            @endforeach
                                            @if($batch->batchItems->count() > 3)
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+{{ $batch->batchItems->count() - 3 }} more items
                                                </div>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-xs">No items</span>
                                    @endif
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    @if($batch->batchItems->count() > 0)
                                        <div class="space-y-2">
                                            @foreach($batch->batchItems->take(3) as $batchItem)
                                                @if($batchItem->variant)
                                                    <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                        <span class="font-medium text-purple-800 flex items-center">
                                                            <i class="fa {{ $batchItem->variant->isLiquidUnit() ? 'fa-flask' : 'fa-weight-hanging' }} mr-1 text-xs"></i>
                                                            {{ $batchItem->variant->display_name }}
                                                        </span>
                                                        @if($batchItem->variant->barcode)
                                                            <div class="text-purple-600 text-xs mt-1">
                                                                <i class="fa fa-barcode mr-1"></i>{{ $batchItem->variant->barcode }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                @else
                                                    <span class="text-gray-400 text-xs">N/A</span>
                                                @endif
                                            @endforeach
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-xs">N/A</span>
                                    @endif
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    @if($batch->supplier)
                                        <div>
                                            <div class="font-semibold">{{ $batch->supplier->name }}</div>
                                            @if($batch->supplier->contact_person)
                                                <div class="text-xs text-gray-500">{{ $batch->supplier->contact_person }}</div>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-gray-400">Not specified</span>
                                    @endif
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    @php
                                        // Calculate totals from batch items
                                        $totalInitialQuantity = $batch->batchItems->sum('initial_quantity');
                                        $totalCurrentQuantity = $batch->batchItems->sum('current_quantity');
                                        $usagePercentage = $totalInitialQuantity > 0 ? (($totalInitialQuantity - $totalCurrentQuantity) / $totalInitialQuantity) * 100 : 0;
                                        $isLowStock = $totalCurrentQuantity <= ($totalInitialQuantity * 0.2);
                                        $isFullyUsed = $totalCurrentQuantity <= 0;
                                    @endphp

                                    @if($batch->batchItems->count() > 0)
                                        <div class="space-y-2">
                                            @foreach($batch->batchItems->take(3) as $batchItem)
                                                @php
                                                    $itemUsagePercentage = $batchItem->initial_quantity > 0 ? (($batchItem->initial_quantity - $batchItem->current_quantity) / $batchItem->initial_quantity) * 100 : 0;
                                                    $itemIsLowStock = $batchItem->current_quantity <= ($batchItem->initial_quantity * 0.2);
                                                    $itemIsFullyUsed = $batchItem->current_quantity <= 0;
                                                @endphp
                                                <div class="text-xs border border-gray-200 rounded p-2">
                                                    <div class="font-medium text-gray-700 mb-1">{{ $batchItem->inventoryItem->name }}</div>
                                                    <div class="flex items-center justify-between mb-1">
                                                        <span class="text-xs">Current:</span>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded
                                                            {{ $itemIsFullyUsed ? 'bg-red-100 text-red-800' : ($itemIsLowStock ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800') }}">
                                                            {{ $batchItem->formatted_current_quantity }}
                                                        </span>
                                                    </div>
                                                    <div class="flex items-center justify-between mb-1">
                                                        <span class="text-xs text-gray-500">Initial:</span>
                                                        <span class="text-xs text-gray-600">{{ $batchItem->formatted_initial_quantity }}</span>
                                                    </div>
                                                    <div class="w-full bg-gray-200 rounded-full h-1">
                                                        <div class="bg-gradient-to-r from-green-400 to-green-600 h-1 rounded-full transition-all duration-300"
                                                             style="width: {{ 100 - $itemUsagePercentage }}%"></div>
                                                    </div>
                                                </div>
                                            @endforeach
                                            @if($batch->batchItems->count() > 3)
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+{{ $batch->batchItems->count() - 3 }} more items
                                                </div>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-xs">No items</span>
                                    @endif
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    @if($batch->batchItems->count() > 0)
                                        <div class="space-y-2">
                                            @foreach($batch->batchItems->take(3) as $batchItem)
                                                @if($batchItem->expiry_date)
                                                    @php
                                                        $isExpired = $batchItem->isExpired();
                                                        $isExpiringSoon = $batchItem->isExpiringSoon();
                                                    @endphp
                                                    <div class="text-xs border border-gray-200 rounded p-2">
                                                        <div class="font-medium text-gray-700 mb-1">{{ $batchItem->inventoryItem->name }}</div>
                                                        <div class="text-sm font-medium
                                                            {{ $isExpired ? 'text-red-600' : ($isExpiringSoon ? 'text-yellow-600' : 'text-green-600') }}">
                                                            {{ $batchItem->expiry_date->format('M d, Y') }}
                                                        </div>
                                                        @if($isExpired)
                                                            <span class="px-1 py-0.5 text-xs font-medium rounded bg-red-100 text-red-800">
                                                                <i class="fa fa-exclamation-triangle mr-1"></i>Expired
                                                            </span>
                                                        @elseif($isExpiringSoon)
                                                            <span class="px-1 py-0.5 text-xs font-medium rounded bg-yellow-100 text-yellow-800">
                                                                @php
                                                                    $days = now()->diffInDays($batchItem->expiry_date, false);
                                                                    $roundedDays = floor(abs($days));
                                                                @endphp
                                                                <i class="fa fa-clock mr-1"></i>
                                                                {{ $roundedDays }} {{ $days < 0 ? 'days ago' : 'days left' }}
                                                            </span>
                                                        @else
                                                            <span class="px-1 py-0.5 text-xs font-medium rounded bg-green-100 text-green-800">
                                                                <i class="fa fa-check mr-1"></i>Valid
                                                            </span>
                                                        @endif
                                                    </div>
                                                @else
                                                    <div class="text-xs border border-gray-200 rounded p-2">
                                                        <div class="font-medium text-gray-700 mb-1">{{ $batchItem->inventoryItem->name }}</div>
                                                        <span class="text-gray-400 text-xs">No expiry</span>
                                                    </div>
                                                @endif
                                            @endforeach
                                            @if($batch->batchItems->count() > 3)
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+{{ $batch->batchItems->count() - 3 }} more items
                                                </div>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-xs">No items</span>
                                    @endif
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    @if($batch->batchItems->count() > 0)
                                        <div class="space-y-2">
                                            @foreach($batch->batchItems->take(3) as $batchItem)
                                                @php
                                                    $itemIsExpired = $batchItem->expiry_date && $batchItem->isExpired();
                                                    $itemIsExpiringSoon = $batchItem->expiry_date && $batchItem->isExpiringSoon();
                                                    $itemIsLowStock = $batchItem->current_quantity <= ($batchItem->initial_quantity * 0.2) && $batchItem->current_quantity > 0;
                                                    $itemIsFullyUsed = $batchItem->current_quantity <= 0;
                                                @endphp
                                                <div class="text-xs border border-gray-200 rounded p-2">
                                                    <div class="font-medium text-gray-700 mb-1">{{ $batchItem->inventoryItem->name }}</div>
                                                    @if($itemIsFullyUsed)
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-gray-100 text-gray-800">
                                                            <i class="fa fa-check-circle mr-1"></i>Fully Used
                                                        </span>
                                                    @elseif($itemIsExpired)
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-red-100 text-red-800">
                                                            <i class="fa fa-exclamation-triangle mr-1"></i>Expired
                                                        </span>
                                                    @elseif($itemIsExpiringSoon)
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-yellow-100 text-yellow-800">
                                                            <i class="fa fa-clock mr-1"></i>Expiring Soon
                                                        </span>
                                                    @elseif($itemIsLowStock)
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-yellow-100 text-yellow-800">
                                                            <i class="fa fa-exclamation-circle mr-1"></i>Low Stock
                                                        </span>
                                                    @else
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-green-100 text-green-800">
                                                            <i class="fa fa-check-circle mr-1"></i>Available
                                                        </span>
                                                    @endif
                                                    <div class="text-xs text-gray-500 mt-1">
                                                        Cost: ${{ number_format($batchItem->unit_cost, 2) }}
                                                    </div>
                                                </div>
                                            @endforeach
                                            @if($batch->batchItems->count() > 3)
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+{{ $batch->batchItems->count() - 3 }} more items
                                                </div>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-xs">No items</span>
                                    @endif
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <button wire:click="openBatchViewModal({{ $batch->id }})"
                                                class="text-purple-600 hover:text-purple-800 transition-colors"
                                                title="View Batch Items">
                                            <i class="fas fa-eye"></i>
                                        </button>

                                        @if($batch->batchItems->where('current_quantity', '>', 0)->count() > 0)
                                            <button wire:click="openStockOutModal({{ $batch->id }})"
                                                    class="text-blue-600 hover:text-blue-800 transition-colors"
                                                    title="Stock Out">
                                                <i class="fas fa-minus-circle"></i>
                                            </button>
                                        @endif

                                        <button wire:click="openTransactionHistoryModal({{ $batch->id }})"
                                                class="text-green-600 hover:text-green-800 transition-colors"
                                                title="Transaction History">
                                            <i class="fas fa-history"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                {{ $stockBatches->links() }}
            </div>
        @else
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                <div class="text-gray-400 mb-4">
                    <i class="fas fa-warehouse text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">
                    @if($search)
                        No stock batches found for "{{ $search }}"
                    @else
                        No Stock Batches Found
                    @endif
                </h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    @if($search)
                        Try adjusting your search terms or clear the search to see all stock batches.
                    @else
                        You don't have any stock batches yet. Record your first stock intake to start tracking inventory.
                    @endif
                </p>
                @if(!$search)
                    <button wire:click="toggleStockIntakeModal"
                            class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                        <i class="fas fa-plus mr-2"></i> Record Stock Intake
                    </button>
                @endif
            </div>
        @endif
    </div>

    <!-- Stock Intake Modal -->
    @if($showStockIntakeModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-4xl w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary">Stock Intake</h3>
                <form wire:submit="saveStockIntake">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Batch Items Section -->
                        <div class="md:col-span-2">
                            <div class="flex justify-between items-center mb-4">
                                <h4 class="text-md font-semibold text-primary">Items in this Batch</h4>
                                <button type="button" wire:click="addBatchItem"
                                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                    <i class="fa fa-plus mr-2"></i>Add Item
                                </button>
                            </div>

                            @if(count($batchItems) > 0)
                                <div class="space-y-4">
                                    @foreach($batchItems as $index => $batchItem)
                                        <div class="border-[2px] border-secondary/40 rounded-md p-4">
                                            <div class="flex justify-between items-center mb-3">
                                                <h5 class="font-medium text-gray-700">Item {{ $index + 1 }}</h5>
                                                @if(count($batchItems) > 1)
                                                    <button type="button" wire:click="removeBatchItem({{ $index }})"
                                                            class="text-red-600 hover:text-red-800 transition-colors"
                                                            title="Remove Item">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                @endif
                                            </div>

                                            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                                <!-- Item Selection -->
                                                <div>
                                                    <label class="font-semibold text-primary">Item <span class="text-danger">*</span></label>
                                                    <select wire:model.live="batchItems.{{ $index }}.inventory_item_id"
                                                            class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <option value="">Select Item</option>
                                                        @foreach($inventoryItems as $item)
                                                            <option value="{{ $item->id }}">
                                                                {{ $item->name }} ({{ ucfirst($item->item_type) }})
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @error("batchItems.{$index}.inventory_item_id") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                </div>

                                                <!-- Variant Selection (for chemicals) -->
                                                @php
                                                    $selectedItem = $batchItem['inventory_item_id'] ? $inventoryItems->find($batchItem['inventory_item_id']) : null;
                                                    $availableVariants = $selectedItem && $selectedItem->isChemical() ? $selectedItem->variants : collect();
                                                @endphp
                                                @if($selectedItem && $selectedItem->isChemical() && $availableVariants->count() > 0)
                                                    <div>
                                                        <label class="font-semibold text-primary">Variant <span class="text-danger">*</span></label>
                                                        <select wire:model="batchItems.{{ $index }}.item_variant_id"
                                                                class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                            <option value="">Select Variant</option>
                                                            @foreach($availableVariants as $variant)
                                                                <option value="{{ $variant->id }}">
                                                                    {{ $variant->display_name }}
                                                                    @if($variant->barcode) - {{ $variant->barcode }} @endif
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        @error("batchItems.{$index}.item_variant_id") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                    </div>
                                                @else
                                                    <div></div> <!-- Empty div to maintain grid layout -->
                                                @endif

                                                <!-- Initial Quantity -->
                                                <div>
                                                    <label class="font-semibold text-primary">
                                                        Initial Quantity <span class="text-danger">*</span>
                                                        @php
                                                            $selectedVariant = $batchItem['item_variant_id'] ? $availableVariants->find($batchItem['item_variant_id']) : null;
                                                        @endphp
                                                        @if($selectedVariant)
                                                            <span class="text-xs text-gray-500">(in {{ $selectedVariant->unit_type }})</span>
                                                        @endif
                                                    </label>
                                                    <input type="number" step="0.01" wire:model="batchItems.{{ $index }}.initial_quantity" min="0.01" placeholder="Enter quantity"
                                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                    @error("batchItems.{$index}.initial_quantity") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                </div>

                                                <!-- Unit Cost -->
                                                <div>
                                                    <label class="font-semibold text-primary">Unit Cost <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" wire:model="batchItems.{{ $index }}.unit_cost" min="0" placeholder="Enter unit cost"
                                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                    @error("batchItems.{$index}.unit_cost") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                </div>

                                                <!-- Manufacturing Date -->
                                                @php
                                                    $selectedItemForDates = $batchItem['inventory_item_id'] ? $inventoryItems->find($batchItem['inventory_item_id']) : null;
                                                @endphp
                                                @if($selectedItemForDates && $selectedItemForDates->isChemical())
                                                    <div>
                                                        <label class="font-semibold text-primary">Manufacture Date <span class="text-danger">*</span></label>
                                                        <input type="date" wire:model="batchItems.{{ $index }}.manufacture_date" max="{{ date('Y-m-d') }}"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        @error("batchItems.{$index}.manufacture_date") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                    </div>

                                                    <!-- Expiry Date -->
                                                    <div>
                                                        <label class="font-semibold text-primary">Expiry Date <span class="text-danger">*</span></label>
                                                        <input type="date" wire:model="batchItems.{{ $index }}.expiry_date" min="{{ date('Y-m-d', strtotime('+1 day')) }}"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        @error("batchItems.{$index}.expiry_date") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                    </div>
                                                @else
                                                    <!-- Optional dates for regular items -->
                                                    <div>
                                                        <label class="font-semibold text-primary">Manufacture Date</label>
                                                        <input type="date" wire:model="batchItems.{{ $index }}.manufacture_date" max="{{ date('Y-m-d') }}"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        @error("batchItems.{$index}.manufacture_date") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                    </div>

                                                    <!-- Expiry Date -->
                                                    <div>
                                                        <label class="font-semibold text-primary">Expiry Date</label>
                                                        <input type="date" wire:model="batchItems.{{ $index }}.expiry_date" min="{{ date('Y-m-d', strtotime('+1 day')) }}"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        @error("batchItems.{$index}.expiry_date") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                    </div>
                                                @endif

                                                <!-- Item Notes -->
                                                <div class="md:col-span-2">
                                                    <label class="font-semibold text-primary">Item Notes</label>
                                                    <textarea wire:model="batchItems.{{ $index }}.notes" placeholder="Enter notes for this item (optional)" rows="2"
                                                              class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                                                    @error("batchItems.{$index}.notes") <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i>{{ $message }}</span> @enderror
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-gray-500 text-sm bg-gray-50 p-4 rounded-lg border-2 border-dashed border-gray-200 text-center">
                                    No items added yet. Click "Add Item" to add items to this batch.
                                </p>
                            @endif
                        </div>

                        <!-- Batch Number -->
                        <div>
                            <label class="font-semibold text-primary">Batch Number <span class="text-danger">*</span></label>
                            <div class="flex gap-2">
                                <input type="text" wire:model="batch_number" wire:blur="validateBatchNumber" placeholder="Enter batch number"
                                       class="px-2 py-2 flex-1 text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <button type="button" wire:click="generateBatchNumber"
                                        class="px-3 py-2 text-sm bg-secondary/80 text-white rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] hover:bg-secondary transition-colors"
                                        title="Generate Batch Number">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </div>
                            @error('batch_number') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <!-- Supplier -->
                        <div>
                            <label class="font-semibold text-primary">Supplier</label>
                            <select wire:model="supplier_id"
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select Supplier (Optional)</option>
                                @foreach($suppliers as $supplier)
                                    <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                                @endforeach
                            </select>
                            @error('supplier_id') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>



                        <!-- Received Date -->
                        <div>
                            <label class="font-semibold text-primary">Received Date <span class="text-danger">*</span></label>
                            <input type="date" wire:model="received_date" max="{{ date('Y-m-d') }}"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('received_date') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>



                        <!-- Notes -->
                        <div class="md:col-span-2">
                            <label class="font-semibold text-primary">Notes</label>
                            <textarea wire:model="notes" placeholder="Enter any additional notes (optional)" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            @error('notes') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <!-- Modal Actions -->
                    <div class="flex justify-end gap-2 mt-6">
                        <button type="button" wire:click="closeStockIntakeModal"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                            Cancel
                        </button>
                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-md hover:bg-primary-dark transition-colors">
                            <i class="fa fa-save mr-2"></i>Record Stock Intake
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Stock Out Modal -->
    @if($showStockOutModal)
        @php
            $selectedBatch = \App\Models\StockBatch::with(['batchItems.inventoryItem', 'batchItems.variant', 'supplier'])->find($selected_batch_id);
            $expiryWarning = $this->checkExpiryWarning();
        @endphp
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary">Stock Out</h3>

                @if($selectedBatch)
                    <!-- Batch Information -->
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <h4 class="font-semibold text-gray-700 mb-2">Batch Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-gray-600">Batch Number:</span>
                                <span class="ml-2 font-semibold">{{ $selectedBatch->batch_number }}</span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Received Date:</span>
                                <span class="ml-2">{{ $selectedBatch->received_date->format('M d, Y') }}</span>
                            </div>
                            @if($selectedBatch->supplier)
                                <div>
                                    <span class="font-medium text-gray-600">Supplier:</span>
                                    <span class="ml-2">{{ $selectedBatch->supplier->name }}</span>
                                </div>
                            @endif
                        </div>
                        @if($selectedBatch->expiry_date)
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm mt-2">
                                <div>
                                    <span class="font-medium text-gray-600">Expiry Date:</span>
                                    <span class="ml-2 {{ $selectedBatch->isExpired() ? 'text-red-600 font-semibold' : ($selectedBatch->isExpiringSoon() ? 'text-yellow-600' : 'text-green-600') }}">
                                        {{ $selectedBatch->expiry_date->format('M d, Y') }}
                                    </span>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Expiry Warning -->
                    @if($expiryWarning)
                        <div class="mb-4 p-4 rounded-lg border-l-4
                            {{ $expiryWarning['type'] === 'expired' ? 'bg-red-50 border-red-400' : 'bg-yellow-50 border-yellow-400' }}">
                            <div class="flex items-center">
                                <i class="fa {{ $expiryWarning['type'] === 'expired' ? 'fa-exclamation-triangle text-red-500' : 'fa-clock text-yellow-500' }} mr-2"></i>
                                <span class="font-medium {{ $expiryWarning['type'] === 'expired' ? 'text-red-800' : 'text-yellow-800' }}">
                                    {{ $expiryWarning['type'] === 'expired' ? 'Expired Item Warning' : 'Expiry Notice' }}
                                </span>
                            </div>
                            <p class="mt-1 text-sm {{ $expiryWarning['type'] === 'expired' ? 'text-red-700' : 'text-yellow-700' }}">
                                {{ $expiryWarning['message'] }}
                            </p>
                            @if($expiryWarning['type'] === 'expired')
                                <div class="mt-3">
                                    <label class="flex items-center">
                                        <input type="checkbox" wire:model="override_expiry" class="mr-2">
                                        <span class="text-sm font-medium text-red-800">I acknowledge this item is expired and approve its usage</span>
                                    </label>
                                    @error('override_expiry') <span class="text-red-500 text-sm block mt-1"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                                </div>
                            @endif
                        </div>
                    @endif

                    <!-- Available Items for Stock Out -->
                    <div class="mb-6">
                        <h4 class="font-semibold text-gray-700 mb-3">Select Items to Stock Out</h4>
                        @if(count($stockOutItems) > 0)
                            <div class="overflow-x-auto">
                                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Select</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Item</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Variant</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Available</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Quantity to Use</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($stockOutItems as $index => $stockOutItem)
                                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-center">
                                                    <input type="checkbox" wire:model="stockOutItems.{{ $index }}.selected" class="rounded">
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    <div class="font-semibold">{{ $stockOutItem['item_name'] }}</div>
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    @if($stockOutItem['variant_name'])
                                                        <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                            <span class="font-medium text-purple-800">{{ $stockOutItem['variant_name'] }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-gray-400 text-xs">N/A</span>
                                                    @endif
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    @php
                                                        $batchItem = \App\Models\BatchItem::find($stockOutItem['batch_item_id']);
                                                        $availableDisplay = $batchItem ? $batchItem->formatted_current_quantity : number_format($stockOutItem['available_quantity'], 2);
                                                    @endphp
                                                    <div class="font-semibold text-green-600">{{ $availableDisplay }}</div>
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    @if($stockOutItem['selected'])
                                                        <input type="number" step="0.01" wire:model="stockOutItems.{{ $index }}.out_quantity"
                                                               min="0.01" max="{{ $stockOutItem['available_quantity'] }}" placeholder="Enter quantity"
                                                               class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] focus:ring-0 focus:outline-none focus:border-primary">
                                                    @else
                                                        <span class="text-gray-400 text-sm">Select item first</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-8 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                                <div class="text-gray-400 mb-4">
                                    <i class="fas fa-box text-4xl"></i>
                                </div>
                                <h3 class="text-lg font-medium text-gray-600 mb-2">No Items Available</h3>
                                <p class="text-gray-500">This batch doesn't have any items available for stock out.</p>
                            </div>
                        @endif
                    </div>
                @endif

                <form wire:submit="saveStockOut">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Used For -->
                        <div>
                            <label class="font-semibold text-primary">Used For <span class="text-danger">*</span></label>
                            <input type="text" wire:model="used_for" placeholder="Experiment/Project name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('used_for') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <!-- Conducted By -->
                        <div>
                            <label class="font-semibold text-primary">Conducted By <span class="text-danger">*</span></label>
                            <input type="text" wire:model="conducted_by" placeholder="Person conducting the usage"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('conducted_by') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <!-- Approved By -->
                        <div>
                            <label class="font-semibold text-primary">Approved By</label>
                            <input type="text" wire:model="approved_by" placeholder="Supervisor/Approver (optional)"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('approved_by') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <!-- Transaction Date -->
                        <div>
                            <label class="font-semibold text-primary">Transaction Date <span class="text-danger">*</span></label>
                            <input type="date" wire:model="transaction_date" max="{{ date('Y-m-d') }}"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('transaction_date') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <!-- Notes -->
                        <div class="md:col-span-2">
                            <label class="font-semibold text-primary">Notes</label>
                            <textarea wire:model="out_notes" placeholder="Enter any additional notes (optional)" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            @error('out_notes') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <!-- Modal Actions -->
                    <div class="flex justify-end gap-2 mt-6">
                        <button type="button" wire:click="closeStockOutModal"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                            Cancel
                        </button>

                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-md hover:bg-blue-700 transition-colors">
                            <i class="fa fa-minus-circle mr-2"></i>Record Stock Out
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Transaction History Modal -->
    @if($showTransactionHistoryModal)
        @php
            $selectedBatch = \App\Models\StockBatch::with(['batchItems.inventoryItem', 'batchItems.variant', 'supplier'])->find($selected_batch_for_history);
        @endphp
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-primary">Transaction History</h3>
                    <button wire:click="closeTransactionHistoryModal" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>

                @if($selectedBatch)
                    <!-- Batch Information Header -->
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-gray-600">Batch Number:</span>
                                <span class="ml-2 font-semibold">{{ $selectedBatch->batch_number }}</span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Received Date:</span>
                                <span class="ml-2">{{ $selectedBatch->received_date->format('M d, Y') }}</span>
                            </div>
                            @if($selectedBatch->supplier)
                                <div>
                                    <span class="font-medium text-gray-600">Supplier:</span>
                                    <span class="ml-2">{{ $selectedBatch->supplier->name }}</span>
                                </div>
                            @endif
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm mt-2">
                            <div>
                                <span class="font-medium text-gray-600">Total Items:</span>
                                <span class="ml-2 font-semibold text-blue-600">{{ $selectedBatch->batchItems->count() }}</span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Items Available:</span>
                                <span class="ml-2 font-semibold text-green-600">{{ $selectedBatch->batchItems->where('current_quantity', '>', 0)->count() }}</span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Items Fully Used:</span>
                                <span class="ml-2 font-semibold text-gray-600">{{ $selectedBatch->batchItems->where('current_quantity', '<=', 0)->count() }}</span>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Transaction History Table -->
                <div class="overflow-x-auto">
                    @if($this->transactionHistory->count() > 0)
                        <table class="w-full border-[2px] border-secondary/40 border-collapse">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Date</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Type</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Quantity</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Remaining</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Used For</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Conducted By</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Approved By</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($this->transactionHistory as $transaction)
                                    <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="flex items-center">
                                                <i class="fa fa-calendar text-primary mr-2"></i>
                                                <div>
                                                    <div class="font-semibold">{{ $transaction->transaction_date->format('M d, Y') }}</div>
                                                    <div class="text-xs text-gray-500">{{ $transaction->created_at->format('H:i') }}</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <span class="px-3 py-1 text-xs font-medium rounded-full
                                                {{ $transaction->transaction_type === 'in' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                <i class="fa {{ $transaction->transaction_type === 'in' ? 'fa-plus' : 'fa-minus' }} mr-1"></i>
                                                {{ $transaction->transaction_type === 'in' ? 'Stock In' : 'Stock Out' }}
                                            </span>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold {{ $transaction->transaction_type === 'in' ? 'text-green-600' : 'text-red-600' }}">
                                                {{ $transaction->transaction_type === 'in' ? '+' : '-' }}
                                                @if($transaction->batchItem && $transaction->batchItem->variant)
                                                    {{ \App\Helpers\UnitConverter::formatBestUnit($transaction->quantity, \App\Helpers\UnitConverter::getBaseUnit($transaction->batchItem->variant->unit_type)) }}
                                                @else
                                                    {{ number_format($transaction->quantity, 2) }}
                                                @endif
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold text-blue-600">
                                                @if($transaction->batchItem && $transaction->batchItem->variant)
                                                    {{ \App\Helpers\UnitConverter::formatBestUnit($transaction->remaining_quantity, \App\Helpers\UnitConverter::getBaseUnit($transaction->batchItem->variant->unit_type)) }}
                                                @else
                                                    {{ number_format($transaction->remaining_quantity, 2) }}
                                                @endif
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="max-w-xs">
                                                <span class="font-semibold">{{ $transaction->used_for }}</span>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="flex items-center">
                                                <i class="fa fa-user text-primary mr-2"></i>
                                                <span>{{ $transaction->conducted_by }}</span>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            @if($transaction->approved_by)
                                                <div class="flex items-center">
                                                    <i class="fa fa-user-check text-green-600 mr-2"></i>
                                                    <span>{{ $transaction->approved_by }}</span>
                                                </div>
                                            @else
                                                <span class="text-gray-400 text-xs">Not specified</span>
                                            @endif
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            @if($transaction->notes)
                                                <div class="max-w-xs">
                                                    <span class="text-sm">{{ Str::limit($transaction->notes, 50) }}</span>
                                                    @if(strlen($transaction->notes) > 50)
                                                        <span class="text-xs text-gray-500 block mt-1" title="{{ $transaction->notes }}">
                                                            <i class="fa fa-info-circle mr-1"></i>Hover for full text
                                                        </span>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-gray-400 text-xs">No notes</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                            <div class="text-gray-400 mb-4">
                                <i class="fas fa-history text-5xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-600 mb-2">No Transaction History</h3>
                            <p class="text-gray-500">No transactions have been recorded for this batch yet.</p>
                        </div>
                    @endif
                </div>

                <!-- Modal Actions -->
                <div class="flex justify-end gap-2 mt-6">
                    <button wire:click="closeTransactionHistoryModal"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                        Close
                    </button>
                </div>
            </div>
        </div>
    @endif
    <!-- Batch View Modal -->
    @if($showBatchViewModal)
        @php
            $selectedBatch = \App\Models\StockBatch::with(['batchItems.inventoryItem', 'batchItems.variant', 'supplier'])->find($selected_batch_for_view);
        @endphp
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-primary">Batch Items</h3>
                    <button wire:click="closeBatchViewModal" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>

                @if($selectedBatch)
                    <!-- Batch Information Header -->
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-gray-600">Batch Number:</span>
                                <span class="ml-2 font-semibold">{{ $selectedBatch->batch_number }}</span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Received Date:</span>
                                <span class="ml-2">{{ $selectedBatch->received_date->format('M d, Y') }}</span>
                            </div>
                            @if($selectedBatch->supplier)
                                <div>
                                    <span class="font-medium text-gray-600">Supplier:</span>
                                    <span class="ml-2">{{ $selectedBatch->supplier->name }}</span>
                                </div>
                            @endif
                        </div>
                        @if($selectedBatch->expiry_date || $selectedBatch->manufacture_date)
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm mt-2">
                                @if($selectedBatch->manufacture_date)
                                    <div>
                                        <span class="font-medium text-gray-600">Manufacture Date:</span>
                                        <span class="ml-2">{{ $selectedBatch->manufacture_date->format('M d, Y') }}</span>
                                    </div>
                                @endif
                                @if($selectedBatch->expiry_date)
                                    <div>
                                        <span class="font-medium text-gray-600">Expiry Date:</span>
                                        <span class="ml-2 {{ $selectedBatch->isExpired() ? 'text-red-600 font-semibold' : ($selectedBatch->isExpiringSoon() ? 'text-yellow-600' : 'text-green-600') }}">
                                            {{ $selectedBatch->expiry_date->format('M d, Y') }}
                                        </span>
                                    </div>
                                @endif
                            </div>
                        @endif
                    </div>
                @endif

                <!-- Batch Items Table -->
                <div class="overflow-x-auto">
                    <!-- Debug Info -->
                    <div class="mb-4 p-2 bg-yellow-100 border border-yellow-400 rounded text-sm">
                        <strong>Debug Info:</strong><br>
                        Selected Batch ID: {{ $selected_batch_for_view }}<br>
                        Batch Items Count: {{ count($batchItemsForView) }}<br>
                        Batch Items Type: {{ gettype($batchItemsForView) }}
                    </div>

                    @if(count($batchItemsForView) > 0)
                        <table class="w-full border-[2px] border-secondary/40 border-collapse">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Item</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Variant</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Initial Qty</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Current Qty</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Used Qty</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Unit Cost</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Status</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($batchItemsForView as $batchItem)
                                    <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="flex items-start">
                                                <i class="fa {{ $batchItem->inventoryItem->item_type === 'chemical' ? 'fa-flask' : 'fa-box' }} text-primary mr-2 text-xs mt-1"></i>
                                                <div>
                                                    <div class="font-semibold">{{ $batchItem->inventoryItem->name }}</div>
                                                    <span class="px-2 py-1 text-xs font-medium rounded-full
                                                        {{ $batchItem->inventoryItem->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800' }}">
                                                        {{ ucfirst($batchItem->inventoryItem->item_type) }}
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            @if($batchItem->variant)
                                                <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                    <span class="font-medium text-purple-800 flex items-center">
                                                        <i class="fa {{ $batchItem->variant->isLiquidUnit() ? 'fa-flask' : 'fa-weight-hanging' }} mr-1 text-xs"></i>
                                                        {{ $batchItem->variant->display_name }}
                                                    </span>
                                                    @if($batchItem->variant->barcode)
                                                        <div class="text-purple-600 text-xs mt-1">
                                                            <i class="fa fa-barcode mr-1"></i>{{ $batchItem->variant->barcode }}
                                                        </div>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-gray-400 text-xs">N/A</span>
                                            @endif
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold text-blue-600">
                                                {{ $batchItem->formatted_initial_quantity }}
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold {{ $batchItem->current_quantity > 0 ? 'text-green-600' : 'text-red-600' }}">
                                                {{ $batchItem->formatted_current_quantity }}
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold text-orange-600">
                                                {{ $batchItem->formatted_used_quantity }}
                                            </div>
                                            <div class="text-xs text-gray-500">
                                                {{ number_format($batchItem->usage_percentage, 1) }}% used
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold">${{ number_format($batchItem->unit_cost, 2) }}</div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            @if($batchItem->current_quantity <= 0)
                                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-red-100 text-red-800">
                                                    <i class="fa fa-times-circle mr-1"></i>Fully Used
                                                </span>
                                            @elseif($batchItem->isLowStock())
                                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-yellow-100 text-yellow-800">
                                                    <i class="fa fa-exclamation-circle mr-1"></i>Low Stock
                                                </span>
                                            @else
                                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800">
                                                    <i class="fa fa-check-circle mr-1"></i>Available
                                                </span>
                                            @endif
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            @if($batchItem->notes)
                                                <div class="max-w-xs">
                                                    <span class="text-sm">{{ Str::limit($batchItem->notes, 50) }}</span>
                                                    @if(strlen($batchItem->notes) > 50)
                                                        <span class="text-xs text-gray-500 block mt-1" title="{{ $batchItem->notes }}">
                                                            <i class="fa fa-info-circle mr-1"></i>Hover for full text
                                                        </span>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-gray-400 text-xs">No notes</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                            <div class="text-gray-400 mb-4">
                                <i class="fas fa-box text-5xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-600 mb-2">No Items in Batch</h3>
                            <p class="text-gray-500">This batch doesn't contain any items yet.</p>
                        </div>
                    @endif
                </div>

                <!-- Modal Actions -->
                <div class="flex justify-end gap-2 mt-6">
                    <button wire:click="closeBatchViewModal"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                        Close
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>
