<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
        <div class="flex flex-col">
            <span class="font-semibold text-primary text-xl">Items & Files for "{{ $itemsSlot->items_slot_name }}"</span>
            <span>
                <a href="{{route('dashboard')}}" class="font-semibold text-danger underline">Home</a>
                <i class="fa fa-angle-right text-xs text-danger"></i>
                <a href="{{route('inventory.storage')}}" class="font-semibold text-success underline">Boxes</a>
                <i class="fa fa-angle-right text-xs text-success"></i>
                <a href="{{route('inventory.sub-boxes', ['id' => $itemsSlot->subBox->box->id])}}" class="font-semibold text-info underline">Sub Boxes</a>
                <i class="fa fa-angle-right text-xs text-info"></i>
                <a href="{{route('inventory.items-slots', ['sub_box_id' => $itemsSlot->subBox->id])}}" class="font-semibold text-warning underline">Items Slots</a>
                <i class="fa fa-angle-right text-xs text-warning"></i>
                <span class="font-normal text-secondary text-sm">Items & Files</span>
            </span>
        </div>

            @if($itemsSlot->status)
                <span wire:click="toggleShowAddNewModal" class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                    <i class="fa fa-plus mr-2"></i>Add Item/File
                </span>
            @else
                <span class="text-sm bg-gray-400 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-gray-400 text-white cursor-not-allowed">
                    <i class="fa fa-lock mr-2"></i>Slot Inactive
                </span>
            @endif
    </div>

    <!-- Slot Statistics -->
    <div class="px-4 py-2 bg-gray-50 border-b border-gray-200">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
            <div class="bg-white p-3 rounded-lg shadow-sm">
                <div class="text-2xl font-bold text-primary">{{ $items->count() }}</div>
                <div class="text-sm text-gray-600">Items</div>
            </div>
            <div class="bg-white p-3 rounded-lg shadow-sm">
                <div class="text-2xl font-bold text-success">{{ $itemsSlot->available_capacity }}</div>
                <div class="text-sm text-gray-600">Available Space</div>
            </div>
            <div class="bg-white p-3 rounded-lg shadow-sm">
                <div class="text-2xl font-bold text-info">{{ $slotFiles->count() }}</div>
                <div class="text-sm text-gray-600">Slot Files</div>
            </div>
            <div class="bg-white p-3 rounded-lg shadow-sm">
                <div class="text-2xl font-bold text-warning">{{ $itemsSlot->items_capacity }}</div>
                <div class="text-sm text-gray-600">Total Capacity</div>
            </div>
        </div>
    </div>

    <div class="w-full overflow-x-auto p-4">
        <!-- Items Section -->
        <div class="mb-10">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-xl font-bold text-primary flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 2a4 4 0 00-4 4v1H5a1 1 0 00-.994.89l-1 9A1 1 0 004 18h12a1 1 0 00.994-1.11l-1-9A1 1 0 0015 7h-1V6a4 4 0 00-4-4zm2 5V6a2 2 0 10-4 0v1h4zm-6 3a1 1 0 112 0 1 1 0 01-2 0zm7-1a1 1 0 100 2 1 1 0 000-2z" clip-rule="evenodd" />
                    </svg>
                    Items Inventory
                    <span class="ml-2 text-sm font-medium bg-primary/10 text-primary px-2 py-0.5 rounded-full">
                {{ $items->count() }}/{{ $itemsSlot->items_capacity }}
            </span>
                </h3>
                @if($items->count() > 0)
                    <div class="text-sm text-gray-500 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        Last updated {{ now()->format('M j, Y') }}
                    </div>
                @endif
            </div>

            @if($items->count() > 0)
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-5">
                    @foreach($items as $item)
                        <div class="bg-white rounded-xl shadow-sm border border-gray-100 hover:shadow-md transition-all duration-200 group relative overflow-hidden">
                            <!-- Item status badge -->
                            <div class="absolute top-3 left-3 z-10">
                                <span class="px-2 py-1 text-xs font-bold leading-none text-white bg-primary/90 rounded-md shadow-sm">ITEM</span>
                            </div>

                            <!-- Action buttons -->
                            <div class="absolute top-3 right-3 z-10 flex space-x-1 opacity-0 group-hover:opacity-100 transition-opacity duration-200">
                                    <button wire:click="loadItemData({{ $item->id }})"
                                            class="p-1.5 rounded-full bg-white/90 backdrop-blur-sm text-primary hover:bg-primary hover:text-white border border-primary shadow-sm"
                                            title="Edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" viewBox="0 0 20 20" fill="currentColor">
                                            <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z" />
                                        </svg>
                                    </button>
                                    <button wire:click="deleteItem({{ $item->id }})"
                                            wire:confirm="Are you sure you want to delete this item?"
                                            class="p-1.5 rounded-full bg-white/90 backdrop-blur-sm text-danger hover:bg-danger hover:text-white border border-danger shadow-sm"
                                            title="Delete">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                            </div>

                            <!-- Item image -->
                            @if($item->item_photo)
                                <div class="relative h-40 overflow-hidden bg-gray-50">
                                    <img src="{{ Storage::url($item->item_photo) }}" alt="{{ $item->item_name }}"
                                         class="absolute inset-0 w-full h-full object-cover transition-transform duration-300 group-hover:scale-105">
                                </div>
                            @else
                                <div class="h-40 bg-gradient-to-br from-primary/5 to-primary/10 flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-primary/30" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                    </svg>
                                </div>
                            @endif

                            <!-- Item details -->
                            <div class="p-4 pt-3">
                                <div class="flex justify-between items-start mb-2">
                                    <h4 class="font-bold text-gray-800 text-sm truncate max-w-[70%]">{{ $item->item_name }}</h4>
                                    <span class="text-xs text-gray-500 bg-gray-100 px-2 py-0.5 rounded-full">
                                {{ $item->created_at->format('M d') }}
                            </span>
                                </div>

                                @if($item->item_info)
                                    <p class="text-xs text-gray-600 mb-3 line-clamp-2">{{ $item->item_info }}</p>
                                @endif

                                <!-- Files section -->
                                @if($item->itemFiles->count() > 0)
                                    <div class="mt-3 pt-3 border-t border-gray-100">
                                        <div class="flex items-center text-xs text-gray-500 mb-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                            {{ $item->itemFiles->count() }} attached files
                                        </div>
                                        <div class="space-y-1.5">
                                            @foreach($item->itemFiles as $file)
                                                <div class="flex items-center justify-between bg-gray-50/70 rounded px-2.5 py-1.5">
                                                    <div class="flex items-center truncate">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5 text-gray-400 mr-1.5 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                                        </svg>
                                                        <span class="text-xs truncate">{{ $file->file_name }}</span>
                                                    </div>
                                                    <div class="flex space-x-1.5 ml-2">
                                                        <button wire:click="viewFile('item', {{ $file->id }})"
                                                                class="text-blue-500 hover:text-blue-700 p-0.5"
                                                                title="View">
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                            </svg>
                                                        </button>
                                                        @can('delete storage')
                                                            <button wire:click="deleteItemFile({{ $file->id }})"
                                                                    wire:confirm="Delete this file?"
                                                                    class="text-red-500 hover:text-red-700 p-0.5">
                                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                                </svg>
                                                            </button>
                                                        @endcan
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12 bg-gray-50/50 rounded-xl border-2 border-dashed border-gray-300 hover:border-primary/30 transition-colors duration-200">
                    <div class="mx-auto w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-primary/40" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                        </svg>
                    </div>
                    <h4 class="text-lg font-medium text-gray-600 mb-1">No items in this slot</h4>
                    <p class="text-sm text-gray-500 max-w-md mx-auto">Add your first item to start organizing your storage.</p>
                    <button class="mt-4 px-4 py-2 bg-primary/10 hover:bg-primary/20 text-primary rounded-lg text-sm font-medium transition-colors">
                        Add New Item
                    </button>
                </div>
            @endif
        </div>

        <!-- Files Section -->
        <div class="mb-10">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-xl font-bold text-info flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd" />
                    </svg>
                    Slot Documents
                    <span class="ml-2 text-sm font-medium bg-info/10 text-info px-2 py-0.5 rounded-full">
                {{ $slotFiles->count() }} files
            </span>
                </h3>
                @if($slotFiles->count() > 0)
                    <div class="text-sm text-gray-500 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 7v10c0 2.21 3.582 4 8 4s8-1.79 8-4V7M4 7c0 2.21 3.582 4 8 4s8-1.79 8-4M4 7c0-2.21 3.582-4 8-4s8 1.79 8 4" />
                        </svg>
                        {{ number_format($slotFiles->sum('file_size') / 1024, 1) }} KB total
                    </div>
                @endif
            </div>

            @if($slotFiles->count() > 0)
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-4">
                    @foreach($slotFiles as $file)
                        <div class="bg-white rounded-lg border border-gray-200 hover:border-info/40 hover:shadow-md transition-all duration-200 group relative overflow-hidden">
                            <!-- File type indicator -->
                            <div class="absolute top-0 left-0 w-full h-1 bg-info/50"></div>

                            <!-- File content -->
                            <div class="p-4">
                                <div class="flex items-start mb-3">
                                    <div class="bg-info/10 p-2.5 rounded-lg mr-3 flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-info" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                        </svg>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <h5 class="font-medium text-gray-800 text-sm truncate mb-1" title="{{ $file->file_name }}">
                                            {{ $file->file_name }}
                                        </h5>
                                        <div class="text-xs text-gray-500">
                                            {{ number_format($file->file_size / 1024, 1) }} KB
                                        </div>
                                    </div>
                                </div>

                                <div class="flex items-center justify-between border-t border-gray-100 pt-3">
                                    <div class="text-xs text-gray-500 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                        </svg>
                                        {{ $file->created_at->format('M d, Y') }}
                                    </div>

                                    <!-- Action buttons -->
                                    <div class="flex space-x-2">
                                        <button wire:click="viewFile('slot', {{ $file->id }})"
                                                class="p-1.5 rounded-full bg-white/90 backdrop-blur-sm text-primary hover:bg-primary hover:text-white border border-primary shadow-sm"
                                                title="View">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                        </button>
                                            <button wire:click="deleteSlotFile({{ $file->id }})"
                                                    wire:confirm="Delete this file?"
                                                    class="p-1.5 rounded-full bg-white/90 backdrop-blur-sm text-danger hover:bg-danger hover:text-white border border-danger shadow-sm"
                                                    title="Delete">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                            </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12 bg-gray-50/50 rounded-xl border-2 border-dashed border-gray-300 hover:border-info/30 transition-colors duration-200">
                    <div class="mx-auto w-16 h-16 bg-info/10 rounded-full flex items-center justify-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-info/40" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 13h6m-3-3v6m-9 1V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2z" />
                        </svg>
                    </div>
                    <h4 class="text-lg font-medium text-gray-600 mb-1">No documents in this slot</h4>
                    <p class="text-sm text-gray-500 max-w-md mx-auto">Upload files to keep them organized with your storage items.</p>
                    <button class="mt-4 px-4 py-2 bg-info/10 hover:bg-info/20 text-info rounded-lg text-sm font-medium transition-colors">
                        Upload Files
                    </button>
                </div>
            @endif
        </div>
    </div>

    @if($showAddNewModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-2xl w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary">
                    {{ $isEditing ? 'Edit Item' : 'Add New Item/File' }}
                </h3>

                @if(!$isEditing)
                    <!-- Upload Type Selection -->
                    <div class="mb-4">
                        <label class="font-semibold text-primary mb-2 block">What would you like to add?</label>
                        <div class="flex gap-4">
                            <label class="flex items-center">
                                <input type="radio" wire:model.live="upload_type" value="item" class="mr-2">
                                <span>Item</span>
                            </label>
                            <label class="flex items-center">
                                <input type="radio" wire:model.live="upload_type" value="file" class="mr-2">
                                <span>Files Only</span>
                            </label>
                        </div>
                    </div>
                @endif

                <form wire:submit="save">
                    @if($upload_type === 'item')
                        <!-- Item Form -->
                        <div class="w-full flex flex-col gap-4">
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Item Name <span class="text-danger">*</span></label>
                                <input type="text" wire:model="item_name" placeholder="Enter item name"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                @error('item_name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>

                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Item Info</label>
                                <textarea wire:model="item_info" placeholder="Enter item information" rows="3"
                                          class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                                @error('item_info') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>

                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Item Photo</label>
                                <input type="file" wire:model="item_photo" accept="image/*"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <div class="text-xs text-gray-500 mt-1">Maximum file size: 2MB</div>
                                @error('item_photo') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>

                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Related Files</label>
                                <input type="file" wire:model="item_files" multiple
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <div class="text-xs text-gray-500 mt-1">Any file type allowed. Maximum file size: 2MB per file</div>
                                @error('item_files.*') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                        </div>
                    @else
                        <!-- Files Form -->
                        <div class="w-full flex flex-col gap-4">
                            @foreach($slot_files as $index => $file)
                                <div class="border border-gray-200 rounded-lg p-4">
                                    <div class="flex justify-between items-center mb-2">
                                        <h4 class="font-medium">File {{ $index + 1 }}</h4>
                                        @if($index > 0)
                                            <button type="button" wire:click="removeFileInput({{ $index }})"
                                                    class="text-red-500 hover:text-red-700">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        @endif
                                    </div>

                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="font-semibold text-primary">File Name <span class="text-danger">*</span></label>
                                            <input type="text" wire:model="file_names.{{ $index }}" placeholder="Enter file name"
                                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                            @error("file_names.{$index}") <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                                        </div>

                                        <div>
                                            <label class="font-semibold text-primary">Select File <span class="text-danger">*</span></label>
                                            <input type="file" wire:model="slot_files.{{ $index }}"
                                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                            <div class="text-xs text-gray-500 mt-1">Any file type allowed. Maximum file size: 2MB</div>
                                            @error("slot_files.{$index}") <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <button type="button" wire:click="addFileInput"
                                    class="text-sm bg-info/30 px-4 py-2 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-info/90 text-ternary hover:text-white hover:bg-info hover:border-ternary/30 transition ease-in duration-2000">
                                <i class="fa fa-plus mr-2"></i>Add Another File
                            </button>
                        </div>
                    @endif

                    <div class="flex justify-end space-x-3 mt-6">
                        <button type="button" wire:click="closeAddNewModal"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">Back</button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="save">{{ $isEditing ? 'Update' : 'Save' }}</span>
                            <span wire:loading wire:target="save">{{ $isEditing ? 'Updating...' : 'Saving...' }} <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Image Modal -->
    <div id="imageModal" class="fixed inset-0 bg-black/80 flex items-center justify-center z-50 hidden">
        <div class="bg-white p-4 rounded-lg shadow-xl max-w-4xl max-h-[90vh] overflow-auto">
            <div class="flex justify-between items-center mb-4">
                <h3 id="imageModalTitle" class="text-lg font-semibold text-primary"></h3>
                <button onclick="closeImageModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <img id="imageModalContent" src="" alt="" class="max-w-full max-h-[70vh] object-contain mx-auto">
        </div>
    </div>

    <!-- PDF Modal -->
    <div id="pdfModal" class="fixed inset-0 bg-black/80 flex items-center justify-center z-50 hidden">
        <div class="bg-white p-4 rounded-lg shadow-xl w-[90vw] h-[90vh]">
            <div class="flex justify-between items-center mb-4">
                <h3 id="pdfModalTitle" class="text-lg font-semibold text-primary"></h3>
                <button onclick="closePdfModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <iframe id="pdfModalContent" src="" class="w-full h-[calc(100%-4rem)] border-0"></iframe>
        </div>
    </div>

    <script>
        // Listen for Livewire events
        document.addEventListener('livewire:init', () => {
            Livewire.on('showImageModal', (event) => {
                const data = event[0];
                document.getElementById('imageModalTitle').textContent = data.name;
                document.getElementById('imageModalContent').src = data.url;
                document.getElementById('imageModal').classList.remove('hidden');
            });

            Livewire.on('showPdfModal', (event) => {
                const data = event[0];
                document.getElementById('pdfModalTitle').textContent = data.name;
                document.getElementById('pdfModalContent').src = data.url;
                document.getElementById('pdfModal').classList.remove('hidden');
            });

            Livewire.on('downloadFile', (event) => {
                const data = event[0];
                const link = document.createElement('a');
                link.href = data.url;
                link.download = data.name;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            });
        });

        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
        }

        function closePdfModal() {
            document.getElementById('pdfModal').classList.add('hidden');
        }

        // Close modals when clicking outside
        document.getElementById('imageModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeImageModal();
            }
        });

        document.getElementById('pdfModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closePdfModal();
            }
        });
    </script>
</div>
