<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
        <div class="flex flex-col">
            @if($userId)
                <span class="font-semibold text-primary text-xl">Items Slots for "{{ $user->name }}"</span>
                <span>
                    <a href="{{route('dashboard')}}" class="font-semibold text-danger underline">Home</a>
                    <i class="fa fa-angle-right text-xs text-danger"></i>
                    <span class="font-normal text-warning text-sm">User Items Slots</span>
                </span>
            @elseif($subBoxId)
                <span class="font-semibold text-primary text-xl">Items Slots for "{{ $subBox->sub_box_name }}"</span>
                <span>
                    <a href="{{route('dashboard')}}" class="font-semibold text-danger underline">Home</a>
                    <i class="fa fa-angle-right text-xs text-danger"></i>
                    <a href="{{route('inventory.storage')}}" class="font-semibold text-success underline">Boxes</a>
                    <i class="fa fa-angle-right text-xs text-success"></i>
                    <a href="{{route('inventory.sub-boxes', ['id' => $subBox->box->id])}}" class="font-semibold text-info underline">Sub Boxes</a>
                    <i class="fa fa-angle-right text-xs text-info"></i>
                    <span class="font-normal text-warning text-sm">Items Slots</span>
                </span>
            @endif
        </div>

        @can('create storage')
            @if($subBoxId)
                <span wire:click="toggleShowAddNewItemsSlotModel" class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                    <i class="fa fa-plus mr-2"></i>Add Items Slot
                </span>
            @endif
        @endcan
    </div>

    <div class="w-full overflow-x-auto p-4">
        @if($itemsSlots->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($itemsSlots as $itemsSlot)
                    <div class="bg-white border-2 border-primary/10 rounded-lg shadow-sm hover:shadow-md transition-all duration-300 relative overflow-hidden group">
                        <!-- Items slot indicator ribbon -->
                        <div class="absolute top-2 left-2 bg-secondary/80 text-white px-2 py-1 rounded-r-md text-[9px] font-bold uppercase tracking-wide">
                            Slot
                        </div>

                        <!-- Edit/Delete buttons -->
                        <div class="absolute top-2 right-2 flex gap-1 opacity-0 group-hover:opacity-100 transition-opacity">
                            @can('view storage')
                                <button wire:click="generateQrCode({{ $itemsSlot->id }})"
                                        class="text-secondary/70 hover:text-secondary transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-white border border-secondary/20 hover:bg-secondary/10"
                                        title="Generate QR Code">
                                    <i class="fas fa-qrcode text-xs"></i>
                                </button>
                            @endcan
                            @can('edit storage')
                                <button wire:click="loadItemsSlotData({{ $itemsSlot->id }})"
                                        class="text-primary/70 hover:text-primary transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-white border border-primary/20 hover:bg-primary/10"
                                        title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>
                            @endcan
                            @can('delete storage')
                                <button wire:click="deleteItemsSlot({{ $itemsSlot->id }})"
                                        wire:confirm="Are you sure you want to delete this items slot?"
                                        class="text-danger/70 hover:text-danger transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-white border border-danger/20 hover:bg-danger/10"
                                        title="Delete">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            @endcan
                        </div>

                        <!-- Inner slot design -->
                        <div class="p-4 pt-7">
                            <div class="mb-3 mt-2">
                                <h4 class="font-bold text-primary text-sm truncate">{{ $itemsSlot->items_slot_name }}</h4>
                                <div class="text-xs text-gray-500 mt-1">ID: {{ $itemsSlot->id }}</div>
                            </div>

                            <!-- Slot details -->
                            <div class="space-y-2 text-sm mb-3">
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-layer-group text-secondary/70"></i>
                                    <span>Capacity: {{ $itemsSlot->items_capacity }}</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-cube text-secondary/70"></i>
                                    <span>Items: {{ $itemsSlot->items_count ?? '0' }}</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-file text-secondary/70"></i>
                                    <span>Files: {{ $itemsSlot->slot_files_count ?? '0' }}</span>
                                </div>
                                @if($itemsSlot->user)
                                    @if(!auth()->user()->hasRole('student'))
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-user text-secondary/70"></i>
                                        <span class="text-xs truncate">{{ $itemsSlot->user->name }}</span>
                                    </div>
                                    @endif
                                @endif
                                @if($userId && $itemsSlot->subBox)
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-box text-secondary/70"></i>
                                        <span class="text-xs truncate">{{$itemsSlot->subBox->box->lab->lab_name}} <i class="fa fa-angle-right text-[11px]"></i> {{$itemsSlot->subBox->box->box_name}} <i class="fa fa-angle-right text-[11px]"></i> {{ $itemsSlot->subBox->sub_box_name }}</span>
                                    </div>
                                @endif
                                @if(!auth()->user()->hasRole('student'))
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-tag text-secondary/70"></i>
                                    <button wire:click="toggleStatus({{ $itemsSlot->id }})"
                                            class="px-2 py-0.5 rounded-full text-xs font-medium cursor-pointer transition-colors {{ $itemsSlot->status ? 'bg-success/20 text-success hover:bg-success/30' : 'bg-danger/20 text-danger hover:bg-danger/30' }}">
                                        {{ $itemsSlot->status ? 'Active' : 'Inactive' }}
                                    </button>
                                </div>
                                @else
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-tag text-secondary/70"></i>
                                        <button
                                                class="px-2 py-0.5 rounded-full text-xs font-medium transition-colors {{ $itemsSlot->status ? 'bg-success/20 text-success hover:bg-success/30' : 'bg-danger/20 text-danger hover:bg-danger/30' }}">
                                            {{ $itemsSlot->status ? 'Active' : 'Inactive' }}
                                        </button>
                                    </div>
                                @endif
                            </div>

                            <!-- Bottom label -->
                            <div class="border-t border-dashed border-gray-200 pt-2">
                                <div class="flex justify-between items-center text-xs text-gray-500">
                                    <div class="text-primary">
                                        <i class="far fa-calendar-alt mr-1 text-danger"></i>
                                        {{ $itemsSlot->created_at->format('M d, Y') }}
                                    </div>
                                        <a href="{{route('inventory.slot-items', ['id' => $itemsSlot->id])}}" class="text-secondary/70 hover:text-secondary text-xs flex items-center">
                                            View Items <i class="fas fa-chevron-right ml-1 text-[10px]"></i>
                                        </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-300">
                <div class="text-secondary/40 mb-4">
                    <i class="fas fa-th-large text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">No Items Slots Found</h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    @if($userId)
                        "{{ $user->name }}" doesn't have any items slots yet.
                    @elseif($subBoxId)
                        "{{ $subBox->sub_box_name }}" doesn't contain any items slots yet.
                    @endif
                </p>
                @can('create storage')
                    @if($subBoxId)
                        <button wire:click="toggleShowAddNewItemsSlotModel"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors text-sm">
                            <i class="fas fa-plus mr-2"></i> Create Items Slot
                        </button>
                    @endif
                @endcan
            </div>
        @endif
    </div>

    @if($showAddNewItemsSlotModel)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">{{ $isEditing ? 'Edit Items Slot' : 'Add New Items Slot' }}</h3>
                <form wire:submit="saveItemsSlot">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Items slot name <span class="text-danger">*</span></label>
                            <input type="text" wire:model="items_slot_name" placeholder="Enter items slot name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('items_slot_name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Items capacity <span class="text-danger">*</span></label>
                            <input type="number" wire:model="items_capacity" placeholder="Enter items capacity" min="1"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('items_capacity') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        @if(count($availableUsers) > 0)
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Assign to User</label>
                                <select wire:model="selected_user_id"
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="">Select User (Optional)</option>
                                    @foreach($availableUsers as $availableUser)
                                        <option value="{{ $availableUser['id'] }}">
                                            {{ $availableUser['name'] }} ({{ $availableUser['type'] }}) - {{ $availableUser['email'] }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('selected_user_id') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                        @endif
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="closeAddNewItemsSlotModel"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">Back</button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveItemsSlot">{{ $isEditing ? 'Update' : 'Save' }}</span>
                            <span wire:loading wire:target="saveItemsSlot">{{ $isEditing ? 'Updating...' : 'Saving...' }} <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    @if($showQrCodeModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
                <!-- Modal Header -->
                <div class="flex justify-between items-center border-b px-6 py-4">
                    <h3 class="text-lg font-semibold">Items Slot QR Code</h3>
                    <button wire:click="$set('showQrCodeModal', false)" class="text-gray-500 hover:text-gray-700">
                        <i class="fa fa-times"></i>
                    </button>
                </div>

                <!-- Modal Content -->
                <div class="p-6">
                    <div class="flex flex-col items-center">
                        @if($qrCodeData)
                            <img src="{{ $qrCodeData }}" alt="QR Code" class="w-64 h-64">
                        @endif

                        <div class="text-center mt-4">
                            <h4 class="font-medium text-gray-900">{{ $selectedItemsSlot->items_slot_name ?? '' }}</h4>
                            @if($selectedItemsSlot && $selectedItemsSlot->user)
                                <p class="text-sm text-gray-600">Assigned to: {{ $selectedItemsSlot->user->name }}</p>
                            @endif
                        </div>

                        <!-- Printing section -->
                        <div class="mt-6 w-full">
                            <div class="flex items-center justify-center gap-2">
                                <input type="number" wire:model="qrCodeCount" min="1" max="100" placeholder="How many QR codes?"
                                       class="px-2 py-1 w-32 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <button wire:click="printQrCodes({{ $selectedItemsSlot->id ?? 0 }})"
                                        class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark transition">
                                    Print QR Codes
                                </button>
                            </div>
                            @error('qrCodeCount')
                            <p class="text-red-500 text-xs mt-1 text-center">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="border-t px-6 py-3 bg-gray-50 flex justify-end">
                    <button wire:click="$set('showQrCodeModal', false)"
                            class="px-4 py-2 bg-danger text-white rounded hover:bg-primary-dark transition">
                        Close
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>
