<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .qr-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10mm;
        }
        .qr-table td {
            width: 20%;
            text-align: center;
            vertical-align: top;
        }
        .qr-code {
            width: 30mm;
            height: 30mm;
            margin: 0 auto;
            display: block;
        }
        .qr-text {
            font-size: 10pt;
            margin-top: 1mm;
        }
        .slot-name {
            font-weight: bold;
        }
        .user-info {
            color: #555;
        }
        .stats {
            color: #007990;
            font-size: 8pt;
        }
        .empty-cell {
            border: none;
        }
    </style>
</head>
<body>
@php
    $qrCodesPerPage = 30;
    $totalPages = ceil($count / $qrCodesPerPage);
@endphp

    <div class="page">
        <h2 style="text-align: center;">Items Slot QR Codes</h2>
        <p style="text-align: center;">
            <span class="slot-name">{{ $itemsSlot->items_slot_name }}</span>
            @if($itemsSlot->user)
                - <span class="user-info">{{ $itemsSlot->user->name }}</span>
            @endif
        </p>
        @for ($page = 0; $page < $totalPages; $page++)
        <table class="qr-table">
            @php
                $start = $page * $qrCodesPerPage;
                $end = min(($page + 1) * $qrCodesPerPage, $count);
                $itemsOnThisPage = $end - $start;
                $rows = ceil($itemsOnThisPage / 5);
            @endphp

            @for ($row = 0; $row < $rows; $row++)
                <tr>
                    @for ($col = 0; $col < 5; $col++)
                        @php
                            $index = $start + ($row * 5) + $col;
                        @endphp

                        @if ($index < $end)
                            <td>
                                <img src="{{ $qrCodeData }}" class="qr-code" alt="QR Code {{ $index + 1 }}">
                                <div class="qr-text">
                                    <div class="slot-name">{{ $itemsSlot->items_slot_name }}</div>
                                    @if($itemsSlot->user)
                                        <div class="user-info">{{ $itemsSlot->user->name }}</div>
                                    @endif
                                    <div class="stats">{{ $itemsSlot->items->count() }} Items</div>
                                    <div class="stats">{{ $itemsSlot->slotFiles->count() }} Files</div>
                                </div>
                            </td>
                        @else
                            <td class="empty-cell"></td>
                        @endif
                    @endfor
                </tr>
            @endfor
        </table>
        @endfor

    </div>
</body>
</html>