<div class="w-full space-y-6">
    <!-- Dashboard Header -->
    <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-primary shadow-lg shadow-gray-300">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
            <span class="font-semibold text-primary text-xl">Laboratory Inventory Dashboard</span>
        </div>
        
        <!-- Statistics Cards -->
        <div class="p-4">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-6 gap-4">
                <div class="bg-gradient-to-r from-blue-50 to-blue-100 p-4 rounded-lg border border-blue-200">
                    <div class="flex items-center">
                        <div class="p-2 bg-blue-500 rounded-lg">
                            <i class="fas fa-boxes text-white text-lg"></i>
                        </div>
                        <div class="ml-3">
                            <div class="text-2xl font-bold text-blue-700">{{ $stats['total_items'] }}</div>
                            <div class="text-sm text-blue-600">Total Items</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-green-50 to-green-100 p-4 rounded-lg border border-green-200">
                    <div class="flex items-center">
                        <div class="p-2 bg-green-500 rounded-lg">
                            <i class="fas fa-warehouse text-white text-lg"></i>
                        </div>
                        <div class="ml-3">
                            <div class="text-2xl font-bold text-green-700">{{ $stats['total_batches'] }}</div>
                            <div class="text-sm text-green-600">Active Batches</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-red-50 to-red-100 p-4 rounded-lg border border-red-200">
                    <div class="flex items-center">
                        <div class="p-2 bg-red-500 rounded-lg">
                            <i class="fas fa-exclamation-triangle text-white text-lg"></i>
                        </div>
                        <div class="ml-3">
                            <div class="text-2xl font-bold text-red-700">{{ $stats['critical_alerts'] }}</div>
                            <div class="text-sm text-red-600">Critical Alerts</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-yellow-50 to-yellow-100 p-4 rounded-lg border border-yellow-200">
                    <div class="flex items-center">
                        <div class="p-2 bg-yellow-500 rounded-lg">
                            <i class="fas fa-arrow-down text-white text-lg"></i>
                        </div>
                        <div class="ml-3">
                            <div class="text-2xl font-bold text-yellow-700">{{ $stats['low_stock_count'] }}</div>
                            <div class="text-sm text-yellow-600">Low Stock</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-orange-50 to-orange-100 p-4 rounded-lg border border-orange-200">
                    <div class="flex items-center">
                        <div class="p-2 bg-orange-500 rounded-lg">
                            <i class="fas fa-clock text-white text-lg"></i>
                        </div>
                        <div class="ml-3">
                            <div class="text-2xl font-bold text-orange-700">{{ $stats['expiring_soon'] }}</div>
                            <div class="text-sm text-orange-600">Expiring Soon</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-purple-50 to-purple-100 p-4 rounded-lg border border-purple-200">
                    <div class="flex items-center">
                        <div class="p-2 bg-purple-500 rounded-lg">
                            <i class="fas fa-dollar-sign text-white text-lg"></i>
                        </div>
                        <div class="ml-3">
                            <div class="text-2xl font-bold text-purple-700">${{ number_format($stats['total_value'], 0) }}</div>
                            <div class="text-sm text-purple-600">Total Value</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-primary shadow-lg shadow-gray-300">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
            <span class="font-semibold text-primary text-lg">Quick Actions</span>
        </div>
        <div class="p-4">
            <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                <a href="{{ route('inventory.stock') }}" 
                   class="flex items-center justify-center p-4 bg-blue-50 hover:bg-blue-100 border border-blue-200 rounded-lg transition-colors group">
                    <div class="text-center">
                        <i class="fas fa-plus-circle text-2xl text-blue-600 group-hover:text-blue-700 mb-2"></i>
                        <div class="text-sm font-medium text-blue-700">Stock Intake</div>
                    </div>
                </a>

                <a href="{{ route('inventory.stock') }}" 
                   class="flex items-center justify-center p-4 bg-green-50 hover:bg-green-100 border border-green-200 rounded-lg transition-colors group">
                    <div class="text-center">
                        <i class="fas fa-minus-circle text-2xl text-green-600 group-hover:text-green-700 mb-2"></i>
                        <div class="text-sm font-medium text-green-700">Stock Out</div>
                    </div>
                </a>

                <a href="{{ route('inventory.items') }}" 
                   class="flex items-center justify-center p-4 bg-purple-50 hover:bg-purple-100 border border-purple-200 rounded-lg transition-colors group">
                    <div class="text-center">
                        <i class="fas fa-box text-2xl text-purple-600 group-hover:text-purple-700 mb-2"></i>
                        <div class="text-sm font-medium text-purple-700">Manage Items</div>
                    </div>
                </a>

                <a href="{{ route('inventory.alerts') }}" 
                   class="flex items-center justify-center p-4 bg-red-50 hover:bg-red-100 border border-red-200 rounded-lg transition-colors group">
                    <div class="text-center">
                        <i class="fas fa-bell text-2xl text-red-600 group-hover:text-red-700 mb-2"></i>
                        <div class="text-sm font-medium text-red-700">View Alerts</div>
                    </div>
                </a>

                <a href="{{ route('inventory.reports') }}" 
                   class="flex items-center justify-center p-4 bg-indigo-50 hover:bg-indigo-100 border border-indigo-200 rounded-lg transition-colors group">
                    <div class="text-center">
                        <i class="fas fa-chart-bar text-2xl text-indigo-600 group-hover:text-indigo-700 mb-2"></i>
                        <div class="text-sm font-medium text-indigo-700">Reports</div>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Critical Alerts -->
        <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-red-500 shadow-lg shadow-gray-300">
            <div class="bg-red-50 px-4 py-2 border-b-[2px] border-b-red-200 flex justify-between items-center">
                <span class="font-semibold text-red-700 text-lg">Critical Alerts</span>
                <a href="{{ route('inventory.alerts') }}" class="text-sm text-red-600 hover:text-red-800">View All</a>
            </div>
            <div class="p-4">
                @if($criticalAlerts->count() > 0)
                    <div class="space-y-3">
                        @foreach($criticalAlerts as $alert)
                            <div class="flex items-start p-3 bg-gray-50 rounded-lg border-l-4 
                                {{ $alert->alert_type === 'low_stock' ? 'border-yellow-400' : 'border-orange-400' }}">
                                <div class="flex-shrink-0 mr-3">
                                    <i class="fas {{ $alert->alert_type === 'low_stock' ? 'fa-exclamation-triangle text-yellow-500' : 'fa-clock text-orange-500' }}"></i>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $alert->inventoryItem->name }}
                                    </div>
                                    <div class="text-xs text-gray-500 mt-1">
                                        {{ $alert->alert_message }}
                                    </div>
                                    <div class="text-xs text-gray-400 mt-1">
                                        {{ $alert->created_at->diffForHumans() }}
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-check-circle text-4xl text-green-400 mb-3"></i>
                        <div class="text-gray-600">No critical alerts</div>
                        <div class="text-sm text-gray-500">All systems are running smoothly</div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Low Stock Items -->
        <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-yellow-500 shadow-lg shadow-gray-300">
            <div class="bg-yellow-50 px-4 py-2 border-b-[2px] border-b-yellow-200 flex justify-between items-center">
                <span class="font-semibold text-yellow-700 text-lg">Low Stock Items</span>
                <a href="{{ route('inventory.items') }}" class="text-sm text-yellow-600 hover:text-yellow-800">View All</a>
            </div>
            <div class="p-4">
                @if($lowStockItems->count() > 0)
                    <div class="space-y-3">
                        @foreach($lowStockItems as $item)
                            @php
                                $currentStock = $item->getCurrentStock();
                                $percentage = $item->min_stock_level > 0 ? ($currentStock / $item->min_stock_level) * 100 : 0;
                            @endphp
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div class="flex items-center">
                                    <i class="fas {{ $item->item_type === 'chemical' ? 'fa-flask' : 'fa-box' }} text-primary mr-3"></i>
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $item->name }}</div>
                                        <div class="text-xs text-gray-500">
                                            Current: {{ $currentStock }} | Min: {{ $item->min_stock_level }}
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-medium text-yellow-600">{{ number_format($percentage, 1) }}%</div>
                                    <div class="w-16 bg-gray-200 rounded-full h-2 mt-1">
                                        <div class="bg-yellow-500 h-2 rounded-full" style="width: {{ min($percentage, 100) }}%"></div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-check-circle text-4xl text-green-400 mb-3"></i>
                        <div class="text-gray-600">All items well stocked</div>
                        <div class="text-sm text-gray-500">No items below minimum levels</div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Expiring Batches -->
        <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-orange-500 shadow-lg shadow-gray-300">
            <div class="bg-orange-50 px-4 py-2 border-b-[2px] border-b-orange-200 flex justify-between items-center">
                <span class="font-semibold text-orange-700 text-lg">Expiring Soon</span>
                <a href="{{ route('inventory.stock') }}" class="text-sm text-orange-600 hover:text-orange-800">View All</a>
            </div>
            <div class="p-4">
                @if($expiringBatches->count() > 0)
                    <div class="space-y-3">
                        @foreach($expiringBatches as $batch)
                            @php
                                $daysUntilExpiry = now()->diffInDays($batch->expiry_date, false);
                            @endphp
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div class="flex items-center">
                                    <i class="fas fa-barcode text-primary mr-3"></i>
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $batch->inventoryItem->name }}</div>
                                        <div class="text-xs text-gray-500">
                                            Batch: {{ $batch->batch_number }}
                                            @if($batch->supplier)
                                                | {{ $batch->supplier->name }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-medium 
                                        {{ $daysUntilExpiry <= 7 ? 'text-red-600' : ($daysUntilExpiry <= 14 ? 'text-orange-600' : 'text-yellow-600') }}">
                                        {{ $daysUntilExpiry }} days
                                    </div>
                                    <div class="text-xs text-gray-500">{{ $batch->expiry_date->format('M d, Y') }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-check-circle text-4xl text-green-400 mb-3"></i>
                        <div class="text-gray-600">No items expiring soon</div>
                        <div class="text-sm text-gray-500">All batches have sufficient shelf life</div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Recent Transactions -->
        <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-blue-500 shadow-lg shadow-gray-300">
            <div class="bg-blue-50 px-4 py-2 border-b-[2px] border-b-blue-200 flex justify-between items-center">
                <span class="font-semibold text-blue-700 text-lg">Recent Transactions</span>
                <a href="{{ route('inventory.stock') }}" class="text-sm text-blue-600 hover:text-blue-800">View All</a>
            </div>
            <div class="p-4">
                @if($recentTransactions->count() > 0)
                    <div class="space-y-3">
                        @foreach($recentTransactions as $transaction)
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 mr-3">
                                        <i class="fas {{ $transaction->transaction_type === 'in' ? 'fa-arrow-up text-green-500' : 'fa-arrow-down text-red-500' }}"></i>
                                    </div>
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $transaction->inventoryItem->name }}</div>
                                        <div class="text-xs text-gray-500">
                                            {{ ucfirst($transaction->transaction_type) }} | {{ $transaction->conducted_by }}
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-medium text-gray-900">{{ $transaction->quantity }}</div>
                                    <div class="text-xs text-gray-500">{{ $transaction->created_at->format('M d, Y') }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-history text-4xl text-gray-400 mb-3"></i>
                        <div class="text-gray-600">No recent transactions</div>
                        <div class="text-sm text-gray-500">Transaction history will appear here</div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>