<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">



    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Categories</span>
        <div class="flex items-center gap-2 justify-end">
            <span wire:click="toggleShowAddNewCategoryModal"
                  class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Add Category
            </span>
        </div>
    </div>

        <div class="w-full px-4 flex flex-col sm:flex-row justify-between gap-2 sm:gap-0">
            <button wire:click="exportCategories"
                    class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                    wire:loading.attr="disabled">
                <span wire:loading.remove wire:target="exportCategories">
                    <i class="fa fa-download mr-2"></i>Export
                </span>
                <span wire:loading wire:target="exportCategories">
                    <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                </span>
            </button>
            <div class="relative w-full sm:w-auto">
                <input type="text" wire:model.live.debounce.500ms="search" placeholder="Search categories..."
                       class="px-3 py-1.5 w-full sm:max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                        <i class="fa fa-times"></i>
                    </button>
                @else
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                @endif
            </div>
        </div>

    <div class="w-full overflow-x-auto p-4 pt-0">
        @if($categories->count() > 0)
            <!-- Desktop Table View -->
            <div class="hidden md:block overflow-x-auto">
                <table class="w-full border-[2px] border-secondary/40 border-collapse"
                       wire:loading.class="opacity-25">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Name</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Description</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Items Count</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Created At</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($categories as $index => $category)
                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    {{ ($categories->currentPage() - 1) * $categories->perPage() + $index + 1 }}
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <i class="fa fa-tag text-primary mr-2 text-xs"></i>{{ $category->name }}
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm max-w-xs overflow-hidden">
                                    {{ $category->description ?? 'No description' }}
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full bg-primary/10 text-primary">
                                        {{ $category->inventory_items_count }} items
                                    </span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <i class="far fa-calendar-alt mr-1 text-danger text-xs"></i>
                                    {{ $category->created_at->format('M d, Y') }}
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <button wire:click="loadCategoryData({{ $category->id }})"
                                                class="text-primary hover:text-primary-dark transition-colors"
                                                title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>

                                        @if($category->inventory_items_count == 0)
                                            <button wire:click="deleteCategory({{ $category->id }})"
                                                    wire:confirm="Are you sure you want to delete this category?"
                                                    class="text-red-600 hover:text-red-800 transition-colors"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @else
                                            <span class="text-gray-400" title="Cannot delete - has associated items">
                                                <i class="fas fa-trash"></i>
                                            </span>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Mobile Card View -->
            <div class="md:hidden space-y-4" wire:loading.class="opacity-25">
                @foreach($categories as $index => $category)
                    <div class="bg-white border-[2px] border-secondary/40 rounded-lg p-4 shadow-sm">
                        <div class="flex justify-between items-start mb-3">
                            <div class="flex-1">
                                <h3 class="font-semibold text-primary flex items-center">
                                    <i class="fa fa-tag text-primary mr-2 text-xs"></i>
                                    {{ $category->name }}
                                </h3>
                                <p class="text-sm text-gray-600 mt-1">
                                    {{ $category->description ?? 'No description' }}
                                </p>
                            </div>
                            <div class="flex items-center gap-2 ml-4">
                                <button wire:click="loadCategoryData({{ $category->id }})"
                                        class="bg-primary/20 text-primary h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000"
                                        title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>

                                @if($category->inventory_items_count == 0)
                                    <button wire:click="deleteCategory({{ $category->id }})"
                                            wire:confirm="Are you sure you want to delete this category?"
                                            class="bg-red-100 text-red-600 h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-red-600 hover:text-white cursor-pointer transition ease-in duration-2000"
                                            title="Delete">
                                        <i class="fas fa-trash text-xs"></i>
                                    </button>
                                @else
                                    <span class="bg-gray-100 text-gray-400 h-8 w-8 flex justify-center items-center rounded-[3px]" title="Cannot delete - has associated items">
                                        <i class="fas fa-trash text-xs"></i>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="flex justify-between items-center text-sm">
                            <span class="px-2 py-1 text-xs font-medium rounded-full bg-primary/10 text-primary">
                                {{ $category->inventory_items_count }} items
                            </span>
                            <span class="text-gray-500">
                                <i class="far fa-calendar-alt mr-1 text-danger text-xs"></i>
                                {{ $category->created_at->format('M d, Y') }}
                            </span>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                {{ $categories->links() }}
            </div>
        @else
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                <div class="text-gray-400 mb-4">
                    <i class="fas fa-tags text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">
                    @if($search)
                        No categories found for "{{ $search }}"
                    @else
                        No Categories Found
                    @endif
                </h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    @if($search)
                        Try adjusting your search terms or clear the search to see all categories.
                    @else
                        You don't have any categories yet. Create your first category to start organizing your inventory items.
                    @endif
                </p>
                @if(!$search)
                    <button wire:click="toggleShowAddNewCategoryModal"
                            class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                        <i class="fas fa-plus mr-2"></i> Create New Category
                    </button>
                @endif
            </div>
        @endif
    </div>

    <!-- Add/Edit Category Modal -->
    @if($showAddNewCategoryModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">{{ $isEditing ? 'Edit Category' : 'Add New Category' }}</h3>
                <form wire:submit="saveCategory">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Name <span class="text-danger">*</span></label>
                            <input type="text" wire:model="name" placeholder="Enter category name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Description</label>
                            <textarea wire:model="description" placeholder="Enter category description (optional)" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            @error('description') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="closeAddNewCategoryModal"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Cancel
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveCategory">{{ $isEditing ? 'Update' : 'Save' }}</span>
                            <span wire:loading wire:target="saveCategory">{{ $isEditing ? 'Updating...' : 'Saving...' }} <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>
