<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .qr-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10mm;
        }
        .qr-table td {
            width: 20%;
            text-align: center;
            vertical-align: top;
        }
        .qr-code {
            width: 30mm;
            height: 30mm;
            margin: 0 auto;
            display: block;
        }
        .qr-text {
            font-size: 10pt;
            margin-top: 1mm;
        }
        .box-name {
            font-weight: bold;
        }
        .lab-info {
            color: #555;
        }
        .stats {
            color: #007990;
            font-size: 8pt;
        }
        .empty-cell {
            border: none;
        }
    </style>
</head>
<body>
@php
    $qrCodesPerPage = 30;
    $totalPages = ceil($count / $qrCodesPerPage);
@endphp

    <div class="page">
        <h2 style="text-align: center;">Storage Box QR Codes</h2>
        <p style="text-align: center;">
            <span class="box-name">{{ $box->box_name }}</span> - 
            <span class="lab-info">{{ $box->lab->lab_name }}</span>
        </p>
        @for ($page = 0; $page < $totalPages; $page++)
        <table class="qr-table">
            @php
                $start = $page * $qrCodesPerPage;
                $end = min(($page + 1) * $qrCodesPerPage, $count);
                $itemsOnThisPage = $end - $start;
                $rows = ceil($itemsOnThisPage / 5);
            @endphp

            @for ($row = 0; $row < $rows; $row++)
                <tr>
                    @for ($col = 0; $col < 5; $col++)
                        @php
                            $index = $start + ($row * 5) + $col;
                        @endphp

                        @if ($index < $end)
                            <td>
                                <img src="{{ $qrCodeData }}" class="qr-code" alt="QR Code {{ $index + 1 }}">
                                <div class="qr-text">
                                    <div class="box-name">{{ $box->box_name }}</div>
                                    <div class="lab-info">{{ $box->lab->lab_name }}</div>
                                    <div class="stats">{{ $box->subBoxes->count() }} Sub-boxes</div>
                                    <div class="stats">{{ $totalItems }} Items | {{ $totalFiles }} Files</div>
                                </div>
                            </td>
                        @else
                            <td class="empty-cell"></td>
                        @endif
                    @endfor
                </tr>
            @endfor
        </table>
        @endfor

    </div>
</body>
</html>