<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .qr-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10mm;
        }
        .qr-table td {
            width: 20%;
            text-align: center;
            vertical-align: top;
        }
        .qr-code {
            width: 30mm;
            height: 30mm;
            margin: 0 auto;
            display: block;
        }
        .qr-text {
            font-size: 10pt;
            margin-top: 1mm;
        }
        .instrument-name {
            font-weight: bold;
        }
        .model-number {
            color: #555;
        }
        .empty-cell {
            border: none;
        }
    </style>
</head>
<body>
@php
    // Calculate total pages based on maximum QR codes that fit per page
    // Each page can fit approximately 15 QR codes (5 columns x 3 rows comfortably)
    $qrCodesPerPage = 30;
    $totalPages = ceil($count / $qrCodesPerPage);
@endphp

    <div class="page">
        <h2 style="text-align: center;">Instrument QR Codes</h2>
        <p style="text-align: center;">
            <span class="instrument-name">{{ $instrument->name }}</span> -
            <span class="model-number">{{ $instrument->model_number }}</span>
        </p>
        @for ($page = 0; $page < $totalPages; $page++)
        <table class="qr-table">
            @php
                $start = $page * $qrCodesPerPage;
                $end = min(($page + 1) * $qrCodesPerPage, $count);
                $itemsOnThisPage = $end - $start;
                $rows = ceil($itemsOnThisPage / 5);
            @endphp

            @for ($row = 0; $row < $rows; $row++)
                <tr>
                    @for ($col = 0; $col < 5; $col++)
                        @php
                            $index = $start + ($row * 5) + $col;
                        @endphp

                        @if ($index < $end)
                            <td>
                                <img src="{{ $qrCodeData }}" class="qr-code" alt="QR Code {{ $index + 1 }}">
                                <div class="qr-text">
                                    <div class="instrument-name">{{ $instrument->name }}</div>
                                    <div class="model-number">{{ $instrument->model_number }}</div>
                                    <div class="serial-number">{{ $instrument->serial_number }}</div>
                                </div>
                            </td>
                        @else
                            <td class="empty-cell"></td>
                        @endif
                    @endfor
                </tr>
            @endfor
        </table>
        @endfor

    </div>
</body>
</html>
