<div>
    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
            <span class="font-semibold text-primary text-xl">
                @if(auth()->user()->hasRole('student'))
                    My Complaints
                @else
                    Instruments Complaints Management
                @endif
            </span>
        </div>
        <div class="w-full overflow-x-auto p-4">
            <div class="w-full flex justify-between gap-2 items-center mb-4">
                <div class="flex gap-2">
                    <!-- Export buttons for admin only -->
{{--                    @if(!auth()->user()->hasRole('student'))--}}
{{--                        <button title="Export to excel" class="bg-success/20 text-success h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">--}}
{{--                            <i class="fa fa-file-excel"></i>--}}
{{--                        </button>--}}
{{--                        <button title="Export to pdf" class="bg-danger/20 text-danger h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">--}}
{{--                            <i class="fa fa-file-pdf"></i>--}}
{{--                        </button>--}}
{{--                    @endif--}}
                </div>
                <div class="flex items-center gap-2">
                    <input type="text" wire:model.live.debounce.1000ms="search" name="search" placeholder="Search complaints"
                           class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>

                    @if(!auth()->user()->hasRole('student'))
                        <select wire:model.live="studentSearch"
                                class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <option value="">Select Student</option>
                            @foreach($students as $student)
                                <option value="{{$student->first_name}}">{{$student->first_name}} {{$student->last_name}}</option>
                            @endforeach
                        </select>
                    @endif

                    <select wire:model.live="instrumentSearch"
                            class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="">Select Instrument</option>
                        @foreach($instruments as $instrument)
                            <option value="{{$instrument->name}}">{{$instrument->name}}</option>
                        @endforeach
                    </select>

                    <select wire:model.live="status"
                            class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="All">All Status</option>
                        <option value="pending">Pending</option>
                        <option value="work_in_progress">Work in Progress</option>
                        <option value="resolved">Resolved</option>
                    </select>
                </div>
            </div>

            <table class="w-full border-[2px] border-secondary/40 border-collapse" wire:loading.class="opacity-25">
                <tr>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Sr. No.</td>
                    @if(!auth()->user()->hasRole('student'))
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Student</td>
                    @endif
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Instrument</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Complaint</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Status</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Date</td>
                    @if(!auth()->user()->hasRole('student'))
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Action</td>
                    @endif
                </tr>

                @forelse ($complaints as $complaint)
                    <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">{{$loop->iteration}}</td>
                        @if(!auth()->user()->hasRole('student'))
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[200px]">
                                <div class="flex items-center gap-2">
                                    @if($complaint->student?->profile_photo)
                                        <img src="{{ asset('storage/' . $complaint->student?->profile_photo) }}" alt="{{ $complaint->student->first_name }}" class="h-8 w-8 object-cover rounded-full"/>
                                    @else
                                        <img src="{{asset('assets/images/noProfile.png')}}" alt="{{ $complaint->student->first_name }}" class="h-8 w-8 object-cover rounded-full"/>
                                    @endif
                                    <div class="w-max">
                                        <span class="text-sm">{{$complaint->student->first_name}} {{$complaint->student->last_name}}</span> <br>
                                        <span class="text-xs">{{ $complaint->student->academic_id }}</span>
                                    </div>
                                </div>
                            </td>
                        @endif
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            @php
                                $routeParams = [ $complaint->instrument->id ];
                                if (auth()->user()->hasRole('student') && auth()->user()->students->first()) {
                                    $routeParams[] = auth()->user()->students->first()->id;
                                }
                            @endphp
                            <a href="{{ route('bookings.create', $routeParams) }}" class="hover:text-danger transition ease-in duration-2000">
                                {{$complaint->instrument->name}}
                            </a>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[300px]">
                            <div class="w-max" style="max-width: 300px">
                                <span class="text-sm">{{ Str::limit($complaint->complaint, 100) }}</span>
                            </div>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[200px]">
                            <div class="w-max" style="max-width: 200px">
                                <span>
                                    @if($complaint->status == 'resolved')
                                        <span class="bg-success/20 text-success px-2 py-0.5 rounded-full text-xs">Resolved</span>
                                    @elseif($complaint->status == 'pending')
                                        <span class="bg-warning/20 text-warning px-2 py-0.5 rounded-full text-xs">Pending</span>
                                    @elseif($complaint->status == 'work_in_progress')
                                        <span class="bg-primary/20 text-primary px-2 py-0.5 rounded-full text-xs">Work in Progress</span>
                                    @endif
                                </span>
                                <br>
                                @if($complaint->remark)
                                    <span class="text-xs"><i class="fa-regular text-{{$complaint->status == 'resolved'?'success':'warning'}} fa-comment mr-1"></i>{{Str::limit($complaint->remark, 50)}}</span>
                                @endif
                                @if($complaint->resolved_by)
                                    <br><span class="text-xs text-gray-500">By: {{$complaint->resolved_by}}</span>
                                @endif
                            </div>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <span class="text-xs">{{$complaint->created_at->format('d M Y')}}</span><br>
                            <span class="text-xs text-gray-500">{{$complaint->created_at->format('h:i A')}}</span>
                        </td>
                        @if(!auth()->user()->hasRole('student'))
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                <div class="flex gap-2">
                                    <button wire:click="updateComplaintStatus({{ $complaint->id }})" title="Update Status" class="bg-primary/20 text-primary h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000">
                                        <i class="fa fa-edit text-xs"></i>
                                    </button>
                                </div>
                            </td>
                        @endif
                    </tr>
                @empty
                    <tr>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center" colspan="{{ auth()->user()->hasRole('student') ? '5' : '7' }}">No complaints found</td>
                    </tr>
                @endforelse
            </table>

            <div class="mt-4">
                {{ $complaints->links() }}
            </div>
        </div>
    </div>

    @if($showStatusModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Update Complaint Status</h3>
                <form wire:submit="saveComplaintStatus">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Status <span class="text-danger">*</span></label>
                            <select wire:model="complaintStatus" required
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">--- select ---</option>
                                <option value="pending">Pending</option>
                                <option value="work_in_progress">Work in Progress</option>
                                <option value="resolved">Resolved</option>
                            </select>
                            @error('complaintStatus') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Remark</label>
                            <textarea wire:model="complaintRemark" rows="3" placeholder="Enter remark or resolution details"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                            @error('complaintRemark') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="$set('showStatusModal', false)"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Cancel
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveComplaintStatus">Update Status</span>
                            <span wire:loading wire:target="saveComplaintStatus">Updating... <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>
