<div>
    @if(!$showBookingDetailsTable)
        <!-- Stats Section -->
        <div class="w-full grid xl:grid-cols-5 lg:grid-cols-3 md:grid-cols-2 sm:grid-cols-2 grid-cols-1 gap-4 mb-6">
            <!-- Instrument Age -->
            <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instrument Age</span>
                    <span class="font-bold text-2xl text-primary">{{ floor((float) $instrumentAge) }} Years</span>
                </div>
                <div>
                    <i class="fa-solid fa-clock text-4xl text-primary"></i>
                </div>
            </div>

            <!-- Total Bookings -->
            <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Total Bookings</span>
                    <span class="font-bold text-2xl text-success">{{$totalBookings}}</span>
                </div>
                <div>
                    <i class="fa-solid fa-calendar-check text-4xl text-success"></i>
                </div>
            </div>

            <!-- Total Services -->
            <div class="w-full border-[1px] border-t-[4px] border-warning/20 border-t-warning bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Total Services</span>
                    <span class="font-bold text-2xl text-warning">{{$totalServices}}</span>
                </div>
                <div>
                    <i class="fa-solid fa-wrench text-4xl text-warning"></i>
                </div>
            </div>

            <!-- Total Expense -->
            <div class="w-full border-[1px] border-t-[4px] border-danger/20 border-t-danger bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Total Expense</span>
                    <span class="font-bold text-2xl text-danger">₹{{number_format($totalExpense)}}</span>
                </div>
                <div>
                    <i class="fa-solid fa-money-bill-transfer text-4xl text-danger"></i>
                </div>
            </div>

            <!-- Total Revenue -->
            <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Total Revenue</span>
                    <span class="font-bold text-2xl text-success">₹{{number_format($totalRevenue)}}</span>
                </div>
                <div>
                    <i class="fa-solid fa-money-bill-trend-up text-4xl text-success"></i>
                </div>
            </div>
        </div>

        <!-- Main Info Card -->
        <div class=" w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex flex-wrap justify-between items-center">

                <span class="font-semibold text-primary text-xl">Instrument Details</span>

                <div class="flex items-center gap-4">
                    <button wire:click="showServiceTable"
                            class="text-sm bg-warning/20 text-warning px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-warning/80 hover:text-white hover:bg-success hover:border-success/30 transition ease-in duration-2000">
                        <i class="fa fa-hammer mr-2"></i>View Services
                    </button>
                    <button wire:click="showForm"
                            class="text-sm bg-success/20 text-success px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 hover:text-white hover:bg-success hover:border-success/30 transition ease-in duration-2000">
                        <i class="fa fa-calendar-check mr-2"></i>View Bookings
                    </button>
                    <button wire:click="hideViewInstrument"
                            class="text-sm bg-danger/20 text-danger px-2 py-0.5 mr-2 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000">
                        <i class="fa fa-xmark"></i>
                    </button>
                </div>

            </div>
            @if($showServicesTable)
                <livewire:instruments.instrument-service-record :instrument="$instrument"
                                                                :for-single-instrument="true"/>
            @endif


            <div class="p-4 grid xl:grid-cols-3 lg:grid-cols-2 gap-6">
                <!-- Basic Information Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-primary/10 p-2 rounded-lg">
                            <i class="fa-solid fa-info-circle text-primary text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-primary text-lg">Basic Information</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Name:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->name}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Model Number:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->model_number}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Serial Number:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->serial_number}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Category:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->instrumentCategory->title}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Lab:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->lab->lab_name}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Status:</span>
                            <span class="font-semibold px-2 py-1 rounded-full text-xs {{$instrument->operating_status === 'working' ? 'bg-success/20 text-success' : 'bg-danger/20 text-danger'}}">
                                {{ucfirst($instrument->operating_status)}}
                            </span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Accessories:</span>
                            <a href="#accessories" class="font-semibold px-2 py-1 rounded-full text-xs bg-danger/20 text-danger cursor-pointer">
                               {{$instrument->instrumentAccessories->count()}}
                            </a>
                        </div>
                        <div class="py-2">
                            <span class="text-gray-900 block mb-2">Description:</span>
                            <div class="bg-white p-3 rounded border">
                                <span class="text-gray-900 cursor-pointer" wire:click="toggleDescription">
                                    {!! $showFullDescription
                                        ? $instrument->description
                                        : \Illuminate\Support\Str::words($instrument->description, 30, '...')
                                    !!}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Purchase Information Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-success/10 p-2 rounded-lg">
                            <i class="fa-solid fa-shopping-cart text-success text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-success text-lg">Purchase Information</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Manufacturer:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->manufacturer_name ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Vendor:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->vendor_name ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Manufacturing Date:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->manufacturing_date ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Purchase Date:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->purchase_date ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Installation Date:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->installation_date ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Purchase Order:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->purchase_order_number ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Purchase Cost:</span>
                            <span class="font-semibold text-success">₹{{number_format($instrument->purchaseInformation->cost ?? 0)}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Funding Source:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->funding_source ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2">
                            <span class="text-gray-900">Warranty Period:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->purchaseInformation->warranty_period ?? 'N/A'}} months</span>
                        </div>
                    </div>
                </div>

                <!-- Booking Information Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-warning/10 p-2 rounded-lg">
                            <i class="fa-solid fa-calendar-check text-warning text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-warning text-lg">Booking Information</h3>
                    </div>

                    <div class="">
                        <!-- Pricing Information -->
                        <div>
                            <h4 class="font-semibold text-gray-700 mb-3">Booking Status</h4>
                            <div class="mb-6 space-y-3">
                                <div class="bg-white p-4 rounded border">
                                    <div class="flex items-center gap-2 mb-2">
                                        <i class="fa-solid fa-clock text-primary"></i>
                                        <span class="font-medium text-gray-700">Upcoming Booking</span>
                                    </div>
                                    <span class="text-gray-900 font-semibold">{{$instrument->getNextBookingDateTime()}}</span>
                                </div>
                                <div class="bg-white p-4 rounded border">
                                    <div class="flex items-center gap-2 mb-2">
                                        <i class="fa-solid fa-calendar-plus text-success"></i>
                                        <span class="font-medium text-gray-700">Next Available Slot</span>
                                    </div>
                                    <span class="text-gray-900 font-semibold">{{$instrument->getNextAvailableSlot()}}</span>
                                </div>
                            </div>

                            @if($instrument->booking_type == 'slot' || $instrument->booking_type == 'both')
                                @isset($instrument->booking_cost['internal']['slot'])
                                    <div class="mb-4">
                                        <h5 class="font-medium text-primary mb-2">Slot Based Pricing</h5>
                                        <div class="bg-white rounded border overflow-hidden">
                                            <table class="w-full text-sm">
                                                <thead class="bg-gray-100">
                                                <tr>
                                                    <th class="text-left p-2 font-medium">Category</th>
                                                    <th class="text-left p-2 font-medium">Rate</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr class="border-t">
                                                    <td class="p-2">Internal</td>
                                                    <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['internal']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['internal']['slot_gst'] ?? 'N/A' }}% GST</td>
                                                </tr>
                                                <tr class="border-t">
                                                    <td class="p-2">Other Educational</td>
                                                    <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['other_educational_institute']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['other_educational_institute']['slot_gst'] ?? 'N/A' }}% GST</td>
                                                </tr>
                                                <tr class="border-t">
                                                    <td class="p-2">R&D Labs</td>
                                                    <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['r_and_d_labs']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['r_and_d_labs']['slot_gst'] ?? 'N/A' }}% GST</td>
                                                </tr>
                                                <tr class="border-t">
                                                    <td class="p-2">Industries</td>
                                                    <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['industries']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['industries']['slot_gst'] ?? 'N/A' }}% GST</td>
                                                </tr>
                                                <tr class="border-t">
                                                    <td class="p-2">Startups</td>
                                                    <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['startups']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['startups']['slot_gst'] ?? 'N/A' }}% GST</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endisset
                                    @isset($instrument->booking_cost['internal']['booking'])
                                        <div class="mb-4">
                                            <h5 class="font-medium text-primary mb-2">Booking Based Pricing</h5>
                                            <div class="bg-white rounded border overflow-hidden">
                                                <table class="w-full text-sm">
                                                    <thead class="bg-gray-100">
                                                    <tr>
                                                        <th class="text-left p-2 font-medium">Category</th>
                                                        <th class="text-left p-2 font-medium">Rate</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="border-t">
                                                        <td class="p-2">Internal</td>
                                                        <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['internal']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['internal']['booking_gst'] ?? 'N/A' }}% GST</td>
                                                    </tr>
                                                    <tr class="border-t">
                                                        <td class="p-2">Other Educational</td>
                                                        <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['other_educational_institute']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['other_educational_institute']['booking_gst'] ?? 'N/A' }}% GST</td>
                                                    </tr>
                                                    <tr class="border-t">
                                                        <td class="p-2">R&D Labs</td>
                                                        <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['r_and_d_labs']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['r_and_d_labs']['booking_gst'] ?? 'N/A' }}% GST</td>
                                                    </tr>
                                                    <tr class="border-t">
                                                        <td class="p-2">Industries</td>
                                                        <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['industries']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['industries']['booking_gst'] ?? 'N/A' }}% GST</td>
                                                    </tr>
                                                    <tr class="border-t">
                                                        <td class="p-2">Startups</td>
                                                        <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['startups']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['startups']['booking_gst'] ?? 'N/A' }}% GST</td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    @endisset
                            @endif

                            @if($instrument->booking_type == 'sample' || $instrument->booking_type == 'both')
                                <div class="mb-4">
                                    <h5 class="font-medium text-primary mb-2">Sample Based Pricing</h5>
                                    <div class="bg-white rounded border overflow-hidden">
                                        <table class="w-full text-sm">
                                            <thead class="bg-gray-100">
                                            <tr>
                                                <th class="text-left p-2 font-medium">Category</th>
                                                <th class="text-left p-2 font-medium">Rate</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr class="border-t">
                                                <td class="p-2">Internal</td>
                                                <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['internal']['sample'] ?? 'N/A' }} + {{ $instrument->booking_cost['internal']['sample_gst'] ?? 'N/A' }}% GST</td>
                                            </tr>
                                            <tr class="border-t">
                                                <td class="p-2">Other Educational</td>
                                                <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['other_educational_institute']['sample'] ?? 'N/A' }} + {{ $instrument->booking_cost['other_educational_institute']['sample_gst'] ?? 'N/A' }}% GST</td>
                                            </tr>
                                            <tr class="border-t">
                                                <td class="p-2">R&D Labs</td>
                                                <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['r_and_d_labs']['sample'] ?? 'N/A' }} + {{ $instrument->booking_cost['r_and_d_labs']['sample_gst'] ?? 'N/A' }}% GST</td>
                                            </tr>
                                            <tr class="border-t">
                                                <td class="p-2">Industries</td>
                                                <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['industries']['sample'] ?? 'N/A' }} + {{ $instrument->booking_cost['industries']['sample_gst'] ?? 'N/A' }}% GST</td>
                                            </tr>
                                            <tr class="border-t">
                                                <td class="p-2">Startups</td>
                                                <td class="p-2 font-semibold">₹{{ $instrument->booking_cost['startups']['sample'] ?? 'N/A' }} + {{ $instrument->booking_cost['startups']['sample_gst'] ?? 'N/A' }}% GST</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endif
                        </div>



                        <!-- Booking Status -->

                    </div>
                </div>

                <!-- Photos and Documents Information Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-success/10 p-2 rounded-lg">
                            <i class="fa fa-photo-film text-success text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-success text-lg">Photos & Documents Information</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="mt-6">
                            <h4 class="font-semibold text-gray-700 mb-3 flex items-center gap-2">
                                <i class="fa-solid fa-images text-primary"></i>
                                Photos
                            </h4>
                            @php
                                $photos = $instrument->photos ? json_decode($instrument->photos, true) : [];
                            @endphp
                            @if(count($photos) > 0)
                                <div class="grid grid-cols-2 gap-2">
                                    @foreach($photos as $key => $photo)
                                        <div class="relative group">
                                            <a href="{{asset('storage/'.$photo)}}" target="_blank">
                                                <img src="{{asset('storage/'.$photo)}}" alt="{{$instrument->name}}"
                                                     class="w-full h-24 object-cover rounded border hover:shadow-lg transition">
                                            </a>
                                            @can('delete instrument')
                                                <button wire:click="deletePhoto({{$key}})"
                                                        wire:confirm="Are you sure you want to delete this photo?"
                                                        class="absolute top-1 right-1 opacity-0 group-hover:opacity-100 text-danger hover:bg-danger/20 p-1 rounded-full transition-all">
                                                    <i class="fa fa-trash text-xs"></i>
                                                </button>
                                            @endcan
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-4 text-gray-500">
                                    <i class="fa-solid fa-image text-2xl mb-2"></i>
                                    <p class="text-sm">No photos available</p>
                                </div>
                            @endif
                        </div>

                        <!-- Documents Section within Basic Info -->
                        <div class="mt-6">
                            <h4 class="font-semibold text-gray-700 mb-3 flex items-center gap-2">
                                <i class="fa-solid fa-file-pdf text-primary"></i>
                                Documents
                            </h4>
                            <div class="space-y-2">
                                @if($instrument->operational_manual)
                                    <div class="flex items-center justify-between bg-white p-3 rounded border">
                                        <a href="{{asset('storage/'.$instrument->operational_manual)}}" target="_blank"
                                           class="flex items-center gap-2 text-primary hover:text-primary/80">
                                            <i class="fa fa-file-pdf text-danger"></i>
                                            <span class="text-sm font-medium">Operation Manual</span>
                                        </a>
                                        @can('delete instrument')
                                            <button wire:click="deleteFile('operational_manual')"
                                                    wire:confirm="Are you sure you want to delete this operational manual?"
                                                    class="text-danger hover:bg-danger/20 p-1 rounded transition-colors">
                                                <i class="fa fa-trash text-xs"></i>
                                            </button>
                                        @endcan
                                    </div>
                                @endif
                                @if($instrument->service_manual)
                                    <div class="flex items-center justify-between bg-white p-3 rounded border">
                                        <a href="{{asset('storage/'.$instrument->service_manual)}}" target="_blank"
                                           class="flex items-center gap-2 text-primary hover:text-primary/80">
                                            <i class="fa fa-file-pdf text-danger"></i>
                                            <span class="text-sm font-medium">Service Manual</span>
                                        </a>
                                        @can('delete instrument')
                                            <button wire:click="deleteFile('service_manual')"
                                                    wire:confirm="Are you sure you want to delete this service manual?"
                                                    class="text-danger hover:bg-danger/20 p-1 rounded transition-colors">
                                                <i class="fa fa-trash text-xs"></i>
                                            </button>
                                        @endcan
                                    </div>
                                @endif
                                @if($instrument->video_link)
                                    <div class="flex items-center justify-between bg-white p-3 rounded border">
                                        <a href="{{asset('storage/'.$instrument->video_link)}}" target="_blank"
                                           class="flex items-center gap-2 text-primary hover:text-primary/80">
                                            <i class="fa fa-video text-success"></i>
                                            <span class="text-sm font-medium">Instrument Video</span>
                                        </a>
                                        @can('delete instrument')
                                            <button wire:click="deleteFile('video_link')"
                                                    wire:confirm="Are you sure you want to delete this video?"
                                                    class="text-danger hover:bg-danger/20 p-1 rounded transition-colors">
                                                <i class="fa fa-trash text-xs"></i>
                                            </button>
                                        @endcan
                                    </div>
                                @endif
                                @if(!$instrument->operational_manual && !$instrument->service_manual && !$instrument->video_link)
                                    <div class="text-center py-4 text-gray-500">
                                        <i class="fa-solid fa-file text-2xl mb-2"></i>
                                        <p class="text-sm">No documents available</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>


                <!-- Service Information Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-danger/10 p-2 rounded-lg">
                            <i class="fa-solid fa-wrench text-danger text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-danger text-lg">Service Information</h3>
                    </div>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Service Engineer:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->engineer_name ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Contact Number:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->engineer_mobile ?? 'N/A'}}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-200">
                            <span class="text-gray-900">Email:</span>
                            <span class="font-semibold text-gray-900">{{$instrument->engineer_email ?? 'N/A'}}</span>
                        </div>
                        <div class="py-2">
                            <span class="text-gray-900 block mb-2">Address:</span>
                            <div class="bg-white p-3 rounded border">
                                <span class="text-gray-900">{{$instrument->engineer_address ?? 'N/A'}}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Terms Information Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-warning/10 p-2 rounded-lg">
                            <i class="fa-solid fa-file-contract text-warning text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-warning text-lg">Terms & Conditions</h3>
                    </div>
                    @if($instrument->instrumentTerm)
                        <div class="space-y-3">
                            <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                <span class="text-gray-900">Cancellation Before:</span>
                                <span class="font-semibold text-gray-900">{{$instrument->instrumentTerm->can_cancel_before_booking_slot}} hours</span>
                            </div>
                            <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                <span class="text-gray-900">Approval Required:</span>
                                <span class="font-semibold px-2 py-1 rounded-full text-xs {{$instrument->instrumentTerm->approval_required ? 'bg-success/20 text-success' : 'bg-danger/20 text-danger'}}">
                                    {{$instrument->instrumentTerm->approval_required ? 'Yes' : 'No'}}
                                </span>
                            </div>
                            @if($instrument->instrumentTerm->approval_required)
                                <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                    <span class="text-gray-900">Approval From:</span>
                                    <span class="font-semibold text-gray-900">{{App\Models\User::find($instrument->instrumentTerm->approval_from)?->name ?? 'Not Set'}}</span>
                                </div>
                            @endif
                            @if($instrument->instrumentTerm->maximum_booking_type)
                                <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                    <span class="text-gray-900">Maximum Booking Type:</span>
                                    <span class="font-semibold text-gray-900">{{ucfirst($instrument->instrumentTerm->maximum_booking_type)}}</span>
                                </div>
                                <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                    <span class="text-gray-900">Maximum Booking For:</span>
                                    <span class="font-semibold text-gray-900">{{ucfirst($instrument->instrumentTerm->maximum_booking_for)}}</span>
                                </div>
                                <div class="flex justify-between items-center py-2">
                                    <span class="text-gray-900">Maximum Bookings:</span>
                                    <span class="font-semibold text-gray-900">{{$instrument->instrumentTerm->maximum_bookings}}</span>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="text-center py-8 text-gray-500">
                            <i class="fa-solid fa-file-circle-exclamation text-4xl mb-2"></i>
                            <p>No terms have been set for this instrument.</p>
                        </div>
                    @endif
                </div>

                <!-- Standard Operation Procedure Card -->
                <div class="bg-gray-50 rounded-lg p-6 border border-gray-200 xl:col-span-3 lg:col-span-2">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="bg-primary/10 p-2 rounded-lg">
                            <i class="fa-solid fa-list-check text-primary text-xl"></i>
                        </div>
                        <h3 class="font-semibold text-primary text-lg">Standard Operation Procedure</h3>
                    </div>
                    @if($instrument->instrumentTerm && $instrument->instrumentTerm->sop)
                        <div class="bg-white p-4 rounded border prose prose-sm max-w-none">
                            {!! $instrument->instrumentTerm->sop !!}
                        </div>
                    @else
                        <div class="text-center py-8 text-gray-500">
                            <i class="fa-solid fa-clipboard-list text-4xl mb-2"></i>
                            <p>No standard operation procedure has been set for this instrument.</p>
                        </div>
                    @endif
                </div>

            </div>
        </div>

        <!-- Accessories Section -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col mt-6" id="accessories">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
                <span class="font-semibold text-primary text-lg flex items-center gap-2">
                    <i class="fa-solid fa-puzzle-piece"></i>
                    Instrument Accessories ({{$instrument->instrumentAccessories->count()}})
                </span>
                <i onclick="document.getElementById('accessoriesDiv').classList.toggle('hidden')" class="fa fa-bars cursor-pointer hover:text-primary/70"></i>
            </div>
            <div id="accessoriesDiv" class="p-6">
                @if($instrument->instrumentAccessories->count() > 0)
                    <div class="grid xl:grid-cols-3 lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-6">
                        @foreach($instrument->instrumentAccessories as $accessory)
                            <div class="bg-gray-50 rounded-lg border border-gray-200 overflow-hidden hover:shadow-lg transition-all duration-300">
                                <div class="relative h-48 w-full overflow-hidden">
                                    @if($accessory->photo)
                                        <img src="{{asset('storage/'.$accessory->photo)}}" alt="{{$accessory->name}}"
                                             class="w-full h-full object-cover">
                                    @else
                                        <img src="{{asset('assets/images/No_Image_Available.jpg')}}" alt="{{$accessory->name}}"
                                             class="w-full h-full object-cover">
                                    @endif
                                    <div class="absolute top-3 right-3">
                                        <span class="px-3 py-1 rounded-full text-xs font-semibold {{$accessory->status === 'available' ? 'bg-success/90 text-white' : 'bg-danger/90 text-white'}}">
                                            {{ucfirst($accessory->status)}}
                                        </span>
                                    </div>
                                    @can('delete instrument')
                                        <button wire:click="deleteAccessory({{ $accessory->id }})"
                                                wire:confirm="Are you sure you want to delete this accessory?"
                                                class="absolute top-3 left-3 opacity-0 group-hover:opacity-100 bg-danger/90 text-white p-2 rounded-full hover:bg-danger transition-all">
                                            <i class="fa fa-trash text-xs"></i>
                                        </button>
                                    @endcan
                                </div>
                                <div class="p-4">
                                    <h4 class="font-semibold text-primary text-lg mb-2">{{$accessory->name}}</h4>
                                    <div class="space-y-2 text-sm">
                                        <div class="flex justify-between">
                                            <span class="text-gray-900">Model:</span>
                                            <span class="font-medium text-gray-900">{{$accessory->model_number ?? 'N/A'}}</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span class="text-gray-900">Purchase Date:</span>
                                            <span class="font-medium text-gray-900">{{$accessory->purchase_date ?? 'N/A'}}</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span class="text-gray-900">Price:</span>
                                            <span class="font-medium text-success">₹{{$accessory->price??0}}   </span>
                                        </div>
                                    </div>
                                    @if($accessory->description)
                                        <div class="mt-3 pt-3 border-t border-gray-200">
                                            <span class="text-gray-900 text-sm block mb-1">Description:</span>
                                            <div class="text-sm text-gray-900 cursor-pointer" wire:click="toggleAccessoryDescription">
                                                {!! $showFullAccessoryDescription
                                                    ? $accessory->description
                                                    : \Illuminate\Support\Str::words($accessory->description, 15, '...')
                                                !!}
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-12 text-gray-500">
                        <div class="bg-gray-100 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4">
                            <i class="fa fa-puzzle-piece text-4xl text-gray-400"></i>
                        </div>
                        <h3 class="text-lg font-medium text-gray-700 mb-2">No Accessories Available</h3>
                        <p class="text-gray-500">This instrument doesn't have any accessories registered yet.</p>
                    </div>
                @endif
            </div>
        </div>

    @endif
    @if($showBookingDetailsTable)
        <!-- Booking Details Table -->
        <livewire:instruments.instrument-booking-table :instrument="$instrument"/>
    @endif
</div>

