<div class="bg-white p-6 rounded-lg shadow-xl max-w-3xl w-full h-max">
    <h3 class="text-lg font-semibold mb-4 text-primary">{{ $isEditing ? 'Update' : 'Add' }} terms for the instrument</h3>
    <form wire:submit="submitTerms">
        <div class="w-full flex flex-col gap-4">
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Can cancel booking before (in hours)</label>
                <input type="number" wire:model="can_cancel_before_booking_slot" placeholder="How much time before user can cancel the booking?" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                @error('can_cancel_before_booking_slot') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>

            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Maximum booking applicable?</label>
                <select wire:model.live="maximum_booking_type" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--select---</option>
                    <option value="day">Day</option>
                    <option value="week">Week</option>
                    <option value="month">Month</option>
                </select>
                @error('maximum_booking_type') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>

            @if($showMoreBookingFields)
                <div class="w-full flex flex-col gap-1">
                    <label class="font-semibold text-primary">Maximum booking applicable for?</label>
                    <select wire:model.live="maximum_booking_for" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="">--select---</option>
                        <option value="pi">Principal Investigator</option>
                    </select>
                    @error('maximum_booking_for') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                </div>

                <div class="w-full flex flex-col gap-1">
                    <label class="font-semibold text-primary">Maximum bookings</label>
                    <input type="number" wire:model="maximum_bookings" placeholder="Maximum booking allowed" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    @error('maximum_bookings') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                </div>
            @endif

            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Maximum sample booking allowed per day</label>
                <input type="number" wire:model="maximum_sample_booking_per_day" placeholder="Maximum samples allowed per day" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                @error('maximum_sample_booking_per_day') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>

            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Booking Slot Duration (in minutes)</label>
                <input type="number" wire:model="booking_slot_duration" placeholder="Duration of each booking slot in minutes" min="15" max="480" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <small class="text-gray-500">Default is 30 minutes. Range: 15 minutes to 8 hours (480 minutes)</small>
                @error('booking_slot_duration') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>

            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Instrument Sample Questions</label>
                @foreach($instrument_sample_questions as $index => $question)
                    <div class="flex items-center gap-2">
                        <input type="text" wire:model="instrument_sample_questions.{{ $index }}" placeholder="Enter question" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <button type="button" wire:click="removeQuestion({{ $index }})" class="text-red-500 hover:text-red-700">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    @error('instrument_sample_questions.' . $index) <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                @endforeach
                <button type="button" wire:click="addQuestion" class="text-sm bg-success/30 px-4 py-1 mt-2 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                    Add More Question
                </button>
            </div>
            <div>
                <label class="font-semibold text-primary">Approval required?</label>
                <select wire:model.live="approval_required" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--select---</option>
                    <option value="1">Yes</option>
                    <option value="0">No</option>
                </select>
                @error('approval_required') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>

            @if($isApprovelRequired)
                <div class="w-full flex flex-col gap-1">
                    <label class="font-semibold text-primary">Approval required from</label>
                    <select wire:model="approval_from" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="">--select---</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                        @endforeach
                    </select>
                    @error('approval_from') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                </div>
            @endif

            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Standard Operation Procedure</label>
                <div wire:ignore>
                    <textarea id="{{ $editorId }}" wire:model="sop" x-data
                              x-init="
                            ClassicEditor
                                .create(document.getElementById('{{ $editorId }}'), {
                                    toolbar: ['heading', '|', 'bold', 'italic', 'link', 'bulletedList', 'numberedList', 'blockQuote'],
                                    heading: {
                                        options: [
                                            { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                                            { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                                            { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                                        ]
                                    }
                                })
                                .then(editor => {
                                    editor.model.document.on('change:data', () => {
                                        @this.set('sop', editor.getData());
                                    });

                                    // Set initial data if editing
                                    @this.on('set-sop-data', (data) => {
                                        editor.setData(data);
                                    });
                                })
                                .catch(error => {
                                    console.error(error);
                                });
                        "
                              class="px-2 py-2 h-[100px] w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        {!! $sop !!}
                    </textarea>
                </div>
                @error('sop') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>
        </div>
        <div class="flex justify-end space-x-3 mt-4">
            <button type="button" wire:click="showInstrumentTermsForm" class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">Back</button>
            <button type="submit" class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                <span wire:loading.remove wire:target="submitTerms">{{ $isEditing ? 'Update' : 'Submit' }} Terms</span>
                <span wire:loading wire:target="submitTerms">{{ $isEditing ? 'Updating' : 'Submitting' }}... <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
            </button>
        </div>
    </form>
</div>
