<div>
    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if($viewInstrumentDetailView)
        <livewire:instruments.instrument-view :instrument="$viewInstrumentDetails"/>
    @else


        <div wire:show="showForm" @if(!$showForm) style="display: none;" @endif class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
                <span
                    class="font-semibold text-primary text-xl">{{ $isEditing ? 'Edit Instrument' : 'Instrument Registration' }}</span>
                <span wire:click="hideForm"
                      class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-primary hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer"><i
                        class="fa fa-angle-left mr-2"></i>Back</span>
            </div>
            <div id="formDiv" class="w-full border-b-[2px] border-b-ternary/10 shadow-lg shadow-ternary/20">
                <livewire:instruments.instrument-form/>
            </div>
        </div>

        <div wire:show="!showForm" class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mt-6">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
                <span class="font-semibold text-primary text-xl">Instrument List</span>
                @can ('create instrument')
                    <span wire:click="hideForm"
                          class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>
                Create New Instrument</span>
                @endcan
            </div>
            @if(!auth()->user()->hasRole('student'))
                <div class="w-full lg:flex md:flex hidden justify-end gap-4 px-4">
                    <div class="flex gap-1 items-center">
                        <button title="Generate QR Code"
                                class="bg-danger/20 text-danger px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                            <i class="fa fa-qrcode text-xs mr-1"></i> <span class="text-sm">Generate QR Code</span>
                        </button>
                    </div>
                    <div class="flex gap-1 items-center">
                        <button title="View"
                                class="bg-success/20 text-success px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                            <i class="fa fa-plus text-xs mr-1"></i> <span class="text-sm">View Accessories</span>
                        </button>
                    </div>
                    <div class="flex gap-1 items-center">
                        <button title="View"
                                class="bg-primary/20 text-primary px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                            <i class="fa fa-eye text-xs mr-1"></i> <span class="text-sm">View Instrument</span>
                        </button>
                    </div>
                    <div class="flex gap-1 items-center">
                        <button title="Edit"
                                class="bg-warning/20 text-warning px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                            <i class="fa fa-edit text-xs mr-1"></i> <span class="text-sm">Edit Instrument</span>
                        </button>
                    </div>
                    <div class="flex gap-1 items-center">
                        <button title="Edit"
                                class="bg-danger/20 text-danger px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                            <i class="fa fa-lock-open text-xs mr-1"></i> <span class="text-sm">Terms Not Created</span>
                        </button>
                    </div>
                    <div class="flex gap-1 items-center">
                        <button title="Edit"
                                class="bg-success/20 text-success px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                            <i class="fa fa-lock text-xs mr-1"></i> <span class="text-sm">Terms Created</span>
                        </button>
                    </div>
                </div>
            @endif

            <div class="w-full p-4">
                <div class="w-full flex flex-col md:flex-row justify-between gap-4 items-center mb-6">
                    <div class="flex gap-2">
                        <button title="{{$gridView?'List View':'Grid View'}}" wire:click="toggleGridView" class="bg-primary/20 text-primary h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000">
                            <i class="fa fa-{{$gridView?'list':'grip'}}"></i>
                        </button>
                        @if(!$gridView)
                            <button title="Export to excel" wire:click="exportToExcel"
                                    class="bg-success/20 text-success h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">
                                <i class="fa fa-file-excel"></i>
                            </button>
                            <button title="Export to pdf" wire:click="exportToPdf"
                                    class="bg-danger/20 text-danger h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                <i class="fa fa-file-pdf"></i>
                            </button>
                        @endif
                    </div>
                    <div class="flex items-center gap-2 flex-1 w-full md:w-auto md:max-w-2xl">
                        <input type="text" wire:model.live.debounce.1000ms="search" name="search" required
                               placeholder="Search Instrument"
                               class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                        <select wire:model.live="status" required
                                class="px-2 py-1 w-40 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <option value="All">All Status</option>
                            <option value="working">Working</option>
                            <option value="under_maintenance">Under Maintenance</option>
                            <option value="calibration_required">Calibration Required</option>
                            <option value="faulty">Faulty</option>
                            <option value="retired">Retired/Obsolete</option>
                        </select>
                    </div>
                </div>

                <div class="flex flex-col lg:flex-row gap-6">
                    <!-- Left Sidebar: Labs List -->
                    <div class="w-full lg:w-[250px] lg:min-w-[100px] shrink-0">
                        <div class="bg-white rounded-lg border border-secondary/20 shadow-sm overflow-hidden sticky top-4">
                            <div class="bg-primary/10 px-4 py-3 border-b border-primary/10">
                                <h3 class="font-semibold text-primary"><i class="fa fa-flask mr-2"></i> Labs</h3>
                            </div>
                            <div class="p-2 max-h-[calc(100vh-200px)] overflow-y-auto custom-scrollbar">
                                <div class="flex flex-col gap-1">
                                    <div wire:click="selectLab(null)"
                                         class="cursor-pointer px-3 py-2 rounded-md text-sm font-medium transition-all duration-200 {{ is_null($selectedLabId) ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-primary/5 hover:text-primary' }}">
                                        <div class="flex items-center justify-between">
                                            <span>All Labs</span>
                                            @if(is_null($selectedLabId)) <i class="fa fa-check text-xs"></i> @endif
                                        </div>
                                    </div>
                                    @foreach($labs as $lab)
                                        <div wire:click="selectLab({{ $lab->id }})"
                                             class="cursor-pointer px-3 py-2 rounded-md text-sm font-medium transition-all duration-200 {{ $selectedLabId == $lab->id ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-primary/5 hover:text-primary' }}">
                                            <div class="flex items-center justify-between">
                                                <span class="truncate" title="{{ $lab->lab_name }}">{{ $lab->lab_name }}</span>
                                                @if($selectedLabId == $lab->id) <i class="fa fa-check text-xs"></i> @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Content: Instruments -->
                    <div class="w-full lg:w-full flex-1 min-w-0">
                        @if($gridView)
                            <div class="w-full grid xl:grid-cols-4 lg:grid-cols-3 md:grid-cols-2 sm:grid-cols-1 gap-4" wire:loading.class="opacity-25">
                                @forelse ($instruments as $instrument)
                                    <div class="w-full p-2 relative flex flex-col items-center group cursor-pointer bg-white border-[2px] border-secondary/20 rounded-lg shadow-sm hover:shadow-md transition-all duration-300">
                                        <div class="absolute -top-2 -right-2">
                                            @if($instrument->operating_status == 'working')
                                                <div class="w-6 h-6 bg-success rounded-full border-2 border-white shadow-sm" title="Working"></div>
                                            @elseif($instrument->operating_status == 'under_maintenance')
                                                <div class="w-6 h-6 bg-warning rounded-full border-2 border-white shadow-sm" title="Under Maintenance"></div>
                                            @elseif($instrument->operating_status == 'calibration_required')
                                                <div class="w-6 h-6 bg-warning rounded-full border-2 border-white shadow-sm" title="Calibration Required"></div>
                                            @elseif($instrument->operating_status == 'faulty')
                                                <div class="w-6 h-6 bg-danger rounded-full border-2 border-white shadow-sm" title="Faulty"></div>
                                            @else
                                                <div class="w-6 h-6 bg-danger rounded-full border-2 border-white shadow-sm" title="Retired/Obsolete"></div>
                                            @endif
                                        </div>

                                        <div class="mb-3 w-full">
                                            @if($instrument->photos)
                                                @php $photos = json_decode($instrument->photos); @endphp
                                                @if(count($photos) > 0)
                                                    <img src="{{ asset('storage/' . $photos[0]) }}"
                                                         alt="{{ $instrument->name }}"
                                                         wire:click="toggleShowImageModal({{ $instrument->id }})"
                                                         class="h-32 w-full object-cover border-[1px] border-primary/30 rounded-sm cursor-pointer hover:opacity-80 "/>
                                                @else
                                                    <div class="h-32 w-full bg-gray-200 border-[2px] border-primary/30 rounded-lg flex items-center justify-center">
                                                        <i class="fa fa-image text-gray-400 text-2xl"></i>
                                                    </div>
                                                @endif
                                            @else
                                                <div class="h-32 w-full bg-gray-200 border-[2px] border-primary/30 rounded-lg flex items-center justify-center">
                                                    <i class="fa fa-image text-gray-400 text-2xl"></i>
                                                </div>
                                            @endif
                                        </div>

                                        <div class="text-center mb-3 flex-1 px-2">
                                            <h3 class="text-sm font-semibold text-ternary/80 mb-1 line-clamp-2" title="{{ $instrument->name }}">
                                                @php
                                                    $routeParams = [ $instrument->id ];
                                                    if (auth()->user()->hasRole('student') && auth()->user()->students->first()) {
                                                        $routeParams[] = auth()->user()->students->first()->id;
                                                    }
                                                @endphp
                                                    <a href="{{ route('bookings.create', $routeParams) }}" >
                                                        {{ $instrument->name }}
                                                    </a>
                                            </h3>
                                            <p class="text-xs text-gray-400 truncate">{{ $instrument->lab->lab_name ?? '' }}</p>
                                        </div>

                                        <div class="w-full flex flex-col gap-2 px-2 pb-2">
                                            @php
                                                $routeParams = [ $instrument->id ];
                                                if (auth()->user()->hasRole('student') && auth()->user()->students->first()) {
                                                    $routeParams[] = auth()->user()->students->first()->id;
                                                }
                                            @endphp

                                            @if(auth()->user()->hasRole('student') && auth()->user()->students->first())
                                                <a href="{{ route('bookings.create', $routeParams) }}"
                                                   class="w-full bg-{{$instrument->operating_status != 'working'?'danger':'success'}}/20 text-{{$instrument->operating_status != 'working'?'danger':'success'}} px-3 py-2 text-xs font-medium rounded-[3px] hover:bg-{{$instrument->operating_status != 'working'?'danger':'success'}} hover:text-white cursor-pointer transition ease-in duration-2000 text-center">
                                                    {{$instrument->operating_status != 'working'?'Notify Me':'Book Now'}}
                                                </a>
                                            @endif

                                            @can ('create instrument')
                                                <div class="flex gap-1 justify-center">
                                                    <button wire:click="viewInstrument({{ $instrument->id }})" title="View"
                                                            class="bg-primary/20 text-primary h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000">
                                                        <i class="fa fa-eye text-xs"></i>
                                                    </button>
                                                    <button wire:click="editInstrument({{ $instrument->id }})" title="Edit"
                                                            class="bg-warning/20 text-warning h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-warning hover:text-white cursor-pointer transition ease-in duration-2000">
                                                        <i class="fa fa-pen text-xs"></i>
                                                    </button>
                                                    <button wire:click="generateQrCode({{ $instrument->id }})" title="Generate QR Code"
                                                            class="bg-danger/20 text-danger h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                                        <i class="fa fa-qrcode text-xs"></i>
                                                    </button>
                                                </div>
                                            @endcan
                                        </div>
                                    </div>
                                @empty
                                    <div class="w-full flex justify-center xl:col-span-4 lg:col-span-3 md:col-span-2 sm:col-span-1">
                                        <div class="text-center py-12">
                                            <div class="text-gray-400 mb-4">
                                                <i class="fas fa-microscope text-5xl"></i>
                                            </div>
                                            <h3 class="text-lg font-medium text-gray-600 mb-2">No Instruments Found</h3>
                                            <p class="text-gray-500">No instruments match your current search criteria.</p>
                                        </div>
                                    </div>
                                @endforelse
                            </div>
                        @else
                            <div class="overflow-x-auto">
                                <table class="w-full border-[2px] border-secondary/40 border-collapse"
                                       wire:loading.class="opacity-25">
                                    <tr>
                                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                            Sr. No.
                                        </td>
                                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                            Instrument
                                        </td>
                                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                            Lab
                                        </td>
                                        @if(!auth()->user()->hasRole('student'))
                                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                                Service Engineer
                                            </td>
                                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                                Accessories
                                            </td>
                                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                                Booking Types
                                            </td>
                                        @endif
                                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                            Status
                                        </td>
                                        @can ('create instrument')
                                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                                Public Visibility
                                            </td>
                                        @endcan
                                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                            Action
                                        </td>
                                    </tr>

                                    @forelse ($instruments as $instrument)
                                        <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">{{$loop->iteration}}</td>
                                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm overflow-x-auto whitespace-nowrap max-w-[300px]">
                                                <div class=" flex w-full items-center gap-2">


                                                    @if($instrument->photos)
                                                        @php $photos = json_decode($instrument->photos); @endphp
                                                        @if(count($photos) > 0)
                                                            <img src="{{ asset('storage/' . $photos[0]) }}"
                                                                 alt="{{ $instrument->name }}"
                                                                 wire:click="toggleShowImageModal({{ $instrument->id }})"
                                                                 class="h-12 w-12 object-cover border-[1px] border-primary/30 shadow-md shadow-primary/10 rounded-full cursor-pointer hover:opacity-80 "/>
                                                        @endif
                                                    @endif

                                                    @php
                                                        $routeParams = [ $instrument->id ];

                                                        if (auth()->user()->hasRole('student') && auth()->user()->students->first()) {
                                                            $routeParams[] = auth()->user()->students->first()->id;
                                                        }
                                                    @endphp

                                                    <a href="{{ route('bookings.create', $routeParams) }}" class="w-full group">
                                                        <span class="text-md group-hover:text-danger">{{ $instrument->name }}</span> <br>
                                                        <span class="mt-1 text-xs">{{ $instrument->instrumentCategory->title ?? '' }}</span>
                                                    </a>
                                                </div>

                                            </td>
                                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap overflow-x-auto max-w-[300px]">
                                                <span><i class="fa fa-vial mr-1 text-success"></i> {{$instrument->lab->lab_name}}</span>
                                                <br>
                                                <span class="text-xs"><i class="fa fa-qrcode mr-1 text-danger"></i> {{$instrument->model_number}}</span>
                                            </td>
                                            @if(!auth()->user()->hasRole('student'))

                                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap overflow-x-auto max-w-[300px]">
                                                    <span><i class="fa fa-user mr-1 text-success"></i> {{$instrument->engineer_name}}</span>
                                                    <br>
                                                    <span class="text-xs"><i class="fa fa-phone mr-1 text-danger"></i> {{$instrument->engineer_mobile}}</span>
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap overflow-x-auto max-w-[300px]">
                                                    <div class="flex items-center gap-2">
                                                        {{$instrument->instrumentAccessories->count()}}
                                                        @can ('create instrument')
                                                            <button wire:click="addAccessories({{ $instrument->id }})" title="Add Accessory"
                                                                    class="bg-success/20 text-success h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">
                                                                <i class="fa fa-plus text-xs"></i>
                                                            </button>
                                                        @endcan
                                                    </div>
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[600px]">
                                                    <div class="grid grid-cols-2 gap-2 text-sm">
                                                        <div class="flex items-center gap-2">
                                                            <span>Booking Type:</span>
                                                            <span class="font-semibold">{{ ucfirst($instrument->booking_type) }}</span>
                                                            <button wire:click="toggleShowPricingModal({{ $instrument->id }})" title="View Pricing"
                                                                    class="bg-danger/20 text-danger flex-none h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                                                <i class="fa fa-eye text-xs"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </td>
                                            @endif
                                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[300px]">
                                                <div class="flex gap-4 items-center">
                                                    <button wire:click="updateStatus({{ $instrument->id }})" class="focus:outline-none">
                                                        @if($instrument->operating_status == 'working')
                                                            <span class="bg-success/10 text-success px-2 py-0.5 rounded-full text-xs">Working</span>
                                                        @elseif($instrument->operating_status == 'under_maintenance')
                                                            <span class="bg-warning/10 text-warning px-2 py-0.5 rounded-full text-xs">Under Maintenance</span>
                                                        @elseif($instrument->operating_status == 'calibration_required')
                                                            <span class="bg-warning/10 text-warning px-2 py-0.5 rounded-full text-xs">Calibration Required</span>
                                                        @elseif($instrument->operating_status == 'faulty')
                                                            <span class="bg-danger/10 text-danger px-2 py-0.5 rounded-full text-xs">Faulty</span>
                                                        @else
                                                            <span class="bg-danger/10 text-danger px-2 py-0.5 rounded-full text-xs">Retired/Obsolete</span>
                                                        @endif
                                                    </button>
                                                    @can ('create instrument')
                                                        @if($instrument->operating_status == 'under_maintenance')
                                                            @if(!$instrument->anyPendingService())
                                                                <button wire:click="sendForService({{ $instrument->id }})"
                                                                        title="Send for service"
                                                                        class="bg-danger/10 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                                                    <i class="fa fa-paper-plane text-xs animate-bounce"></i>
                                                                </button>
                                                            @endif
                                                        @endif
                                                    @endcan
                                                </div>
                                            </td>
                                            @can ('create instrument')
                                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[300px]">
                                                    <div class="flex gap-4 items-center">
                                                        <button wire:click="updatePublicStatus({{ $instrument->id }})" class="focus:outline-none">
                                                            @if($instrument->public_visibility_status)
                                                                <span class="bg-success/10 text-success px-2 py-0.5 rounded-full text-xs">Visible</span>
                                                            @else
                                                                <span class="bg-danger/10 text-danger px-2 py-0.5 rounded-full text-xs">Not Visible</span>
                                                            @endif
                                                        </button>
                                                    </div>
                                                </td>
                                            @endcan

                                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[300px]">
                                                <div class="flex gap-2">
                                                    @if(auth()->user()->hasRole('student') && auth()->user()->students->first())

                                                        <a href="{{ route('bookings.create', [$instrument->id, auth()->user()->students->first()->id]) }}"
                                                           title="Notify Me"
                                                           class="bg-{{$instrument->operating_status != 'working'?'danger':'success'}}/20 text-{{$instrument->operating_status != 'working'?'danger':'success'}} px-4 py-0.5 flex justify-center items-center rounded-[3px] hover:bg-{{$instrument->operating_status != 'working'?'danger':'success'}} hover:text-white cursor-pointer transition ease-in duration-2000">
                                                            {{$instrument->operating_status != 'working'?'Notify Me':'Book Now'}}
                                                        </a>
                                                        <button wire:click="openComplaintModal({{ $instrument->id }})"
                                                                title="Raise complaint for this instrument"
                                                                class="bg-warning/20 text-warning h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-warning hover:text-white cursor-pointer transition ease-in duration-2000">
                                                            <i class="fa fa-exclamation-triangle text-xs"></i>
                                                        </button>
                                                    @endif
                                                    @can ('create instrument')
                                                        <button wire:click="generateQrCode({{ $instrument->id }})"
                                                                title="Generate QR Code"
                                                                class="bg-danger/20 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                                            <i class="fa fa-qrcode text-xs"></i>
                                                        </button>
                                                        <button wire:click="viewInstrument({{ $instrument->id }})" title="View"
                                                                class="bg-primary/20 text-primary h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000">
                                                            <i class="fa fa-eye text-xs"></i>
                                                        </button>
                                                        <button wire:click="editInstrument({{ $instrument->id }})" title="Edit"
                                                                class="bg-warning/20 text-warning h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-warning hover:text-white cursor-pointer transition ease-in duration-2000">
                                                            <i class="fa fa-pen text-xs"></i>
                                                        </button>
                                                        <button wire:click="createInstrumentTerms({{ $instrument->id }})"
                                                                title="Create terms"
                                                                class="bg-{{$instrument->instrumentTerm?'success':'danger'}}/20 text-{{$instrument->instrumentTerm?'success':'danger'}} h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-{{$instrument->instrumentTerm?'success':'danger'}} hover:text-white cursor-pointer transition ease-in duration-2000">
                                                            <i class="fa fa-{{$instrument->instrumentTerm?'lock':'lock-open'}} text-xs"></i>
                                                        </button>
                                                    @endcan
                                                </div>
                                            </td>

                                        </tr>
                                    @empty
                                        <tr>
                                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center"
                                                colspan="10">No instruments found
                                            </td>
                                        </tr>
                                    @endforelse
                                </table>
                                <div class="mt-4">
                                    {{ $instruments->links() }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    @endif

    @can ('create instrument')
        @if($showStatusModal)
            <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
                <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                    <h3 class="text-lg font-semibold mb-4 text-primary">Update Instrument Status</h3>
                    <form wire:submit.prevent="confirmStatusUpdate">
                        <div class="w-full flex flex-col gap-4">
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Status <span
                                        class="text-danger">*</span></label>
                                <select wire:model.live="selectedStatus" required
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="">Select Status</option>
                                    <option value="working">Working</option>
                                    <option value="under_maintenance">Under Maintenance</option>
                                    <option value="calibration_required">Calibration Required</option>
                                    <option value="faulty">Faulty</option>
                                    <option value="retired">Retired/ Obsolete</option>
                                </select>
                                @error('selectedStatus') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="flex justify-end space-x-3 mt-4">
                            <button type="button" wire:click="$set('showStatusModal', false)"
                                    class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                Back
                            </button>
                            <button type="submit"
                                    class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                                <span wire:loading.remove wire:target="confirmStatusUpdate">Update Status</span>
                                <span wire:loading wire:target="confirmStatusUpdate">Updating... <i
                                        class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        @endif
    @endcan

    @if($showInstrumentTermsForm)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <livewire:instruments.instrument-terms-form :instrument="$addTermsForInstrument"/>
        </div>
    @endif

    @if($showQrCodeModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
                <!-- Modal Header -->
                <div class="flex justify-between items-center border-b px-6 py-4">
                    <h3 class="text-lg font-semibold">Instrument QR Code</h3>
                    <button wire:click="$set('showQrCodeModal', false)" class="text-gray-500 hover:text-gray-700">
                        <i class="fa fa-times"></i>
                    </button>
                </div>

                <!-- Modal Content -->
                <div class="p-6">
                    <div class="flex flex-col items-center">
                        @if($qrCodeData)
                            <img src="{{ $qrCodeData }}" alt="QR Code" class="w-64 h-64">
                        @endif

                        <div class="text-center">
                            <h4 class="font-medium text-gray-900">{{ $instrument->name }}</h4>
                        </div>

                        <!-- Updated printing section -->
                        <div class="mt-6 w-full">
                            <div class="flex items-center justify-center gap-2">
                                <input type="number" wire:model="qrCodeCount" min="1" max="100" placeholder="How many qr codes?"
                                       class="px-2 py-1 w-20 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <button wire:click="printQrCodes({{ $instrument->id }})"
                                        class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark transition">
                                    Print QR Codes
                                </button>
                            </div>
                            @error('qrCodeCount')
                            <p class="text-red-500 text-xs mt-1 text-center">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="border-t px-6 py-3 bg-gray-50 flex justify-end">
                    <button wire:click="$set('showQrCodeModal', false)"
                            class="px-4 py-2 bg-danger text-white rounded hover:bg-primary-dark transition">
                        Close
                    </button>
                </div>
            </div>
        </div>
    @endif

    @can ('create instrument')
        @if($showAccessoryModal)
            <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
                <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                    <h3 class="text-lg font-semibold mb-4 text-primary">Add Accessory</h3>
                    <form wire:submit="submitAccessory">
                        <div class="w-full flex flex-col gap-4">
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Name <span
                                        class="text-danger">*</span></label>
                                <input type="text" wire:model="accessoryName" placeholder="Enter accessory name"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                @error('accessoryName') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Model Number </label>
                                <input type="text" wire:model="accessoryModelNumber"
                                       placeholder="Enter model number"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                @error('accessoryModelNumber') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Purchase Date</label>
                                <input type="date" wire:model="accessoryPurchaseDate"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                @error('accessoryPurchaseDate') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Price </label>
                                <input type="number" wire:model="accessoryPrice" placeholder="Enter price"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                @error('accessoryPrice') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Description </label>
                                <textarea wire:model="accessoryDescription" rows="3" placeholder="Enter description"
                                          class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                                @error('accessoryDescription') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Status </label>
                                <select wire:model="accessoryStatus"
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="available">Available</option>
                                    <option value="notAvailable">Not Available</option>
                                </select>
                                @error('accessoryStatus') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Photo </label>
                                <span class="text-danger text-xs">*Max size: 2MB</span>
                                <input type="file" wire:model="accessoryPhoto" accept="image/*"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <div wire:loading wire:target="accessoryPhoto" class="text-sm text-danger"><i
                                        class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please
                                    wait
                                </div>
                                @error('accessoryPhoto') <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="flex justify-end space-x-3 mt-4">
                            <button type="button" wire:click="$set('showAccessoryModal', false)"
                                    class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                Back
                            </button>
                            <button type="submit" id="submitButton"
                                    class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                                <span wire:loading.remove wire:target="submitAccessory">Submit Accessory</span>
                                <span wire:loading wire:target="submitAccessory">Submitting... <i
                                        class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        @endif
    @endcan

    @if($showPricingModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Instrument Pricing Details</h3>
                @if($selectedInstrumentForPricing)
                    <div class="w-full flex flex-col gap-4">
                        @if($selectedInstrumentForPricing->booking_type == 'slot' || $selectedInstrumentForPricing->booking_type == 'both')
                            <div class="w-full flex flex-col gap-2">
                                @isset($selectedInstrumentForPricing->booking_cost['internal']['slot'])
                                    <h4 class="font-semibold text-primary">Slot Based Pricing</h4>
                                    <div class="grid grid-cols-2 gap-2 text-sm">
                                        <span>Internal:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['internal']['slot'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['internal']['slot_gst'] ?? 'N/A' }}% GST</span>
                                        <span>Other Educational:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['other_educational_institute']['slot'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['other_educational_institute']['slot_gst'] ?? 'N/A' }}% GST</span>
                                        <span>R&D Labs:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['r_and_d_labs']['slot'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['r_and_d_labs']['slot_gst'] ?? 'N/A' }}% GST</span>
                                        <span>Industries:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['industries']['slot'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['industries']['slot_gst'] ?? 'N/A' }}% GST</span>
                                        <span>Startups:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['startups']['slot'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['startups']['slot_gst'] ?? 'N/A' }}% GST</span>
                                    </div>
                                @endisset
                                @isset($selectedInstrumentForPricing->booking_cost['internal']['booking'])
                                    <h4 class="font-semibold text-primary">Booking Based Pricing</h4>
                                    <div class="grid grid-cols-2 gap-2 text-sm">
                                        <span>Internal:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['internal']['booking'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['internal']['booking_gst'] ?? 'N/A' }}% GST</span>
                                        <span>Other Educational:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['other_educational_institute']['booking'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['other_educational_institute']['booking_gst'] ?? 'N/A' }}% GST</span>
                                        <span>R&D Labs:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['r_and_d_labs']['booking'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['r_and_d_labs']['booking_gst'] ?? 'N/A' }}% GST</span>
                                        <span>Industries:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['industries']['booking'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['industries']['booking_gst'] ?? 'N/A' }}% GST</span>
                                        <span>Startups:</span>
                                        <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['startups']['booking'] ?? 'N/A' }} + {{ $selectedInstrumentForPricing->booking_cost['startups']['booking_gst'] ?? 'N/A' }}% GST</span>
                                    </div>
                                @endisset
                            </div>
                        @endif
                        @if($selectedInstrumentForPricing->booking_type == 'sample' || $selectedInstrumentForPricing->booking_type == 'both')
                            <div class="w-full flex flex-col gap-2">
                                <h4 class="font-semibold text-primary">Sample Based Pricing</h4>
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['internal']['sample'] ?? 'N/A' }}+ {{ $selectedInstrumentForPricing->booking_cost['internal']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['other_educational_institute']['sample'] ?? 'N/A' }}+ {{ $selectedInstrumentForPricing->booking_cost['other_educational_institute']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['r_and_d_labs']['sample'] ?? 'N/A' }}+ {{ $selectedInstrumentForPricing->booking_cost['r_and_d_labs']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['industries']['sample'] ?? 'N/A' }}+ {{ $selectedInstrumentForPricing->booking_cost['industries']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹{{ $selectedInstrumentForPricing->booking_cost['startups']['sample'] ?? 'N/A' }}+ {{ $selectedInstrumentForPricing->booking_cost['startups']['sample_gst'] ?? 'N/A' }}% GST</span>
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button wire:click="hidePricingModal"
                                class="text-sm bg-danger/20 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-danger hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000">
                            Close
                        </button>
                    </div>
                @endif
            </div>
        </div>
    @endif

    @if($showInstrumentTermsForm)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <livewire:instruments.instrument-terms-form :instrument="$addTermsForInstrument"/>
        </div>
    @endif

    @if($showImageModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-4xl w-full max-h-[90vh] overflow-y-auto">
                <div class="flex justify-between items-start mb-4 border-b pb-2">
                    <h3 class="text-lg font-semibold text-primary">Instrument Details: <i>{{ $selectedInstrumentForImage->name }}</i></h3>
                    <button wire:click="hideImageModal" class="text-gray-500 hover:text-gray-700 transition-colors">
                        <i class="fa fa-times text-xl"></i>
                    </button>
                </div>

                @if($selectedInstrumentForImage)
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Left Column: Image & Status -->
                        <div class="flex flex-col gap-4">
                            <div class="text-center bg-gray-50 p-4 rounded-lg border border-gray-200 min-h-[200px] flex items-center justify-center">
                                @if($selectedInstrumentForImage->photos)
                                    @php $photos = json_decode($selectedInstrumentForImage->photos); @endphp
                                    @if(count($photos) > 0)
                                        <img src="{{ asset('storage/' . $photos[0]) }}"
                                             alt="{{ $selectedInstrumentForImage->name }}"
                                             class="max-w-full max-h-80 object-contain mx-auto rounded-lg shadow-sm"/>
                                    @else
                                        <div class="flex flex-col items-center justify-center text-gray-400">
                                            <i class="fa fa-image text-5xl mb-2"></i>
                                            <span>No image available</span>
                                        </div>
                                    @endif
                                @else
                                    <div class="flex flex-col items-center justify-center text-gray-400">
                                        <i class="fa fa-image text-5xl mb-2"></i>
                                        <span>No image available</span>
                                    </div>
                                @endif
                            </div>

                            <div class="bg-blue-50/50 p-4 rounded-lg border border-blue-100">
                                <h4 class="font-semibold text-primary mb-2 text-sm uppercase tracking-wide">Current Status</h4>
                                <div>
                                    @if($selectedInstrumentForImage->operating_status == 'working')
                                        <span class="bg-success/10 text-success px-3 py-1 rounded-full text-sm font-medium border border-success/20 inline-flex items-center gap-1">
                                            <i class="fa fa-check-circle"></i> Working
                                        </span>
                                    @elseif($selectedInstrumentForImage->operating_status == 'under_maintenance')
                                        <span class="bg-warning/10 text-warning px-3 py-1 rounded-full text-sm font-medium border border-warning/20 inline-flex items-center gap-1">
                                            <i class="fa fa-tools"></i> Under Maintenance
                                        </span>
                                    @elseif($selectedInstrumentForImage->operating_status == 'calibration_required')
                                        <span class="bg-warning/10 text-warning px-3 py-1 rounded-full text-sm font-medium border border-warning/20 inline-flex items-center gap-1">
                                            <i class="fa fa-exclamation-circle"></i> Calibration Required
                                        </span>
                                    @elseif($selectedInstrumentForImage->operating_status == 'faulty')
                                        <span class="bg-danger/10 text-danger px-3 py-1 rounded-full text-sm font-medium border border-danger/20 inline-flex items-center gap-1">
                                            <i class="fa fa-times-circle"></i> Faulty
                                        </span>
                                    @else
                                        <span class="bg-danger/10 text-danger px-3 py-1 rounded-full text-sm font-medium border border-danger/20 inline-flex items-center gap-1">
                                            <i class="fa fa-ban"></i> Retired/Obsolete
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Right Column: Details -->
                        <div class="flex flex-col gap-4">
                            <div class="bg-white rounded-lg space-y-4">
                                <!-- Manufacturer -->
                                <div class="border-b border-gray-100 pb-3">
                                    <span class="text-xs text-gray-500 uppercase tracking-wider block mb-1">Manufacturer</span>
                                    <span class="font-medium text-gray-800 text-lg">
                                        {{ $selectedInstrumentForImage->purchaseInformation->manufacturer_name ?? 'N/A' }}
                                    </span>
                                </div>

                                <!-- Lab -->
                                <div class="border-b border-gray-100 pb-3">
                                    <span class="text-xs text-gray-500 uppercase tracking-wider block mb-1">Lab Location</span>
                                    <span class="font-medium text-gray-800 text-lg">
                                        <i class="fa fa-flask text-primary/70 mr-1"></i>
                                        {{ $selectedInstrumentForImage->lab->lab_name ?? 'N/A' }}
                                    </span>
                                </div>

                                <!-- Funding Agency -->
                                <div class="border-b border-gray-100 pb-3">
                                    <span class="text-xs text-gray-500 uppercase tracking-wider block mb-1">Funding Agency</span>
                                    <span class="font-medium text-gray-800 text-lg">
                                        {{ $selectedInstrumentForImage->purchaseInformation->funding_source ?? 'N/A' }}
                                    </span>
                                </div>

                                <!-- Available Accessories -->
                                <div>
                                    <span class="text-xs text-gray-500 uppercase tracking-wider block mb-2">Available Accessories</span>
                                    @if($selectedInstrumentForImage->instrumentAccessories->count() > 0)
                                        <div class="flex flex-wrap gap-2">
                                            @foreach($selectedInstrumentForImage->instrumentAccessories as $accessory)
                                                <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm border border-gray-200">
                                                    {{ $accessory->name }}
                                                </span>
                                            @endforeach
                                        </div>
                                    @else
                                        <span class="text-gray-400 italic">No accessories listed</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Usage Guidelines (SOP) -->
                    <div class="mt-8 pt-6 border-t border-gray-200">
                        <h4 class="font-semibold text-primary mb-3 flex items-center gap-2">
                            <i class="fa fa-book-open"></i> Usage Guidelines (SOP)
                        </h4>
                        <div class="bg-gray-50 p-5 rounded-lg border border-gray-200 text-sm text-gray-700 max-h-60 overflow-y-auto prose prose-sm max-w-none">
                            @if(!empty($selectedInstrumentForImage->instrumentTerm->sop))
                                {!! $selectedInstrumentForImage->instrumentTerm->sop !!}
                            @else
                                <p class="text-gray-400 italic flex items-center justify-center py-4">
                                    <i class="fa fa-info-circle mr-2"></i> No usage guidelines available.
                                </p>
                            @endif
                        </div>
                    </div>

                    <div class="flex justify-end space-x-3 mt-6 pt-4 border-t border-gray-100">
                        <button wire:click="hideImageModal"
                                class="text-sm bg-danger/20 px-6 py-2 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-danger hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000 shadow-sm hover:shadow-md">
                            Close
                        </button>
                    </div>
                @endif
            </div>
        </div>
    @endif

    @if($showComplaintModal)
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Report Instrument Issue</h3>
                <form wire:submit="submitOtherComplaint">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Instrument</label>
                            <input type="text" value="{{ $selectedInstrumentForComplaint?->name }}" readonly
                                   class="px-2 py-2 w-full text-sm font-medium bg-gray-100 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none">
                        </div>
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Complaint <span class="text-danger">*</span></label>
                            <textarea wire:model="complaintText" rows="4" placeholder="Describe the issue with this instrument"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                            @error('complaintText') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="$set('showComplaintModal', false)"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Cancel
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="submitOtherComplaint">Submit Complaint</span>
                            <span wire:loading wire:target="submitOtherComplaint">Submitting... <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>

