<div>
    <form wire:submit.prevent="submit" wire:loading.class="opacity-50">
        <div class="w-full grid lg:grid-cols-4 gap-2 p-4">
            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mb-4">
                Basic Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Instrument Category <span class="text-danger">*</span></label>
                <select wire:model="instrument_category" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--- select category ---</option>
                @foreach($instrumentCategories as $category)
                        <option value="{{$category->id}}">{{$category->title}}</option>
                    @endforeach
                </select>
                @error('instrument_category') <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Lab <span class="text-danger">*</span></label>
                <select wire:model="lab" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--- select lab ---</option>
                @foreach($labs as $lab)
                        <option value="{{$lab->id}}">{{$lab->lab_name}}</option>
                    @endforeach
                </select>
                @error('lab') <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Lab In-Charge</label>
                <select wire:model="technician" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--- select lab in-charge ---</option>
                @foreach($technicians as $person)
                        <option value="{{$person->id}}">{{$person->getFullNameAttribute()}}</option>
                    @endforeach
                </select>
                @error('lab') <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Name <span class="text-danger">*</span></label>
                <input type="text" wire:model="name"  placeholder="Instrument name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Model Number </label>
                <input type="text" wire:model="model_number"  placeholder="Model number"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('model_number') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Serial Number</label>
                <input type="text" wire:model="serial_number"  placeholder="Serial number"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('serial_number') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Description</label>
                <textarea wire:model="description" name="description" rows="1" placeholder="Enter category description"
                          class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                @error('description') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>

            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Booking Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Operating Status </label>
                <select wire:model="operating_status" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="working">Working</option>
                        <option value="under_maintenance">Under Maintenance</option>
                        <option value="calibration_required">Calibration Required</option>
                        <option value="faulty">Faulty</option>
                        <option value="retired">Retired/ Obsolete</option>
                </select>
                @error('operating_status') <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Booking Type <span class="text-danger">*</span></label>
                <select wire:model.live="booking_type" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">-- select booking type --</option>
                    <option value="slot">Slot Based</option>
                    <option value="sample">Sample Based</option>
                    <option value="both">Both</option>
                </select>
                @error('booking_type') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>

            @if($booking_type == 'sample' || $booking_type == 'both')
            <div class="w-full lg:col-span-4">
                <div class="font-semibold text-primary mb-2">Sample Based Pricing</div>
                <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Internal (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.internal.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.internal.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Educational Institute (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.other_educational_institute.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.other_educational_institute.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">R&D Labs (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.r_and_d_labs.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.r_and_d_labs.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Industries (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.industries.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.industries.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Startups (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.startups.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.startups.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            @if($booking_type == 'slot' || $booking_type == 'both')
            <div class="w-full lg:col-span-4">
                <div class="flex items-center gap-4 mb-2">
                    <div class="font-semibold text-primary">{{ucfirst($slot_pricing_type)}} Based Pricing</div>
                    <select wire:model.live="slot_pricing_type" class="px-2 py-1 text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary">
                        <option value="slot">Per Slot</option>
                        <option value="booking">Per Booking</option>
                    </select>
                </div>
                <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Internal (₹/{{ $slot_pricing_type }})</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.internal.{{ $slot_pricing_type }}" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.internal.{{ $slot_pricing_type }}_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Educational Institute (₹/{{ $slot_pricing_type }})</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.other_educational_institute.{{ $slot_pricing_type }}" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.other_educational_institute.{{ $slot_pricing_type }}_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">R&D Labs (₹/{{ $slot_pricing_type }})</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.r_and_d_labs.{{ $slot_pricing_type }}" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.r_and_d_labs.{{ $slot_pricing_type }}_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Industries (₹/{{ $slot_pricing_type }})</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.industries.{{ $slot_pricing_type }}" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.industries.{{ $slot_pricing_type }}_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Startups (₹/{{ $slot_pricing_type }})</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.startups.{{ $slot_pricing_type }}" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.startups.{{ $slot_pricing_type }}_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                </div>
            </div>
            @endif





            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Purchase Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Manufacturer Name</label>
                <input type="text" wire:model="manufacturer_name"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('manufacturer_name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Manufacturing Date</label>
                <input type="date" wire:model="manufacturing_date"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('manufacturing_date') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Purchase Date </label>
                <input type="date" wire:model="purchase_date"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('purchase_date') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Purchase Order Number</label>
                <input type="text" wire:model="purchase_order_number"  placeholder="Purchase order number"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('purchase_order_number') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Cost (₹) </label>
                <input type="number" wire:model="cost"  placeholder="Cost"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('cost') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Funding Source </label>
                <input type="text" wire:model="funding_source"  placeholder="Funding Source"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('funding_source') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Installation Date </label>
                <input type="date" wire:model="installation_date"  placeholder="Funding Source"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('installation_date') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Service Engineer Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Engineer Name  <span class="text-danger">*</span></label>
                <input type="text" wire:model="engineer_name"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('engineer_name') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Email  <span class="text-danger">*</span></label>
                <input type="email" wire:model="engineer_email"  placeholder="Email"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('engineer_email') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Mobile Number  <span class="text-danger">*</span></label>
                <input type="number" wire:model="engineer_mobile"  placeholder="Mobile Number" oninput="if(this.value.length > 15) this.value=this.value.slice(0,15)"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('engineer_mobile') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary"> Address <span class="text-danger">*</span></label>
                <textarea wire:model="engineer_address" rows="2" placeholder="Address" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                @error('engineer_address') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>



            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Photos and Documents
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Instrument Photos<span class="text-danger">*</span></label>
                <span class="text-danger text-xs">*Max size: 2MB</span>
                <input type="file" wire:model="photos"  placeholder="" multiple accept="image/png, image/jpeg, image/jpg"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <div wire:loading wire:target="photos" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please wait</div>

                @error('photos') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Operational Manual (pdf)</label>
                <span class="text-danger text-xs">*Max size: 2MB</span>
                <input type="file" wire:model="operational_manual"  placeholder=""
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <div wire:loading wire:target="operational_manual" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please wait</div>

                @error('operational_manual') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Service Manual (pdf)</label>
                <span class="text-danger text-xs">*Max size: 2MB</span>
                <input type="file" wire:model="service_manual"  placeholder=""
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <div wire:loading wire:target="service_manual" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please wait</div>
                @error('service_manual') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Video Link (url)</label>
                <span class="text-danger text-xs">&nbsp</span>
                <input type="text" wire:model="video_link"  placeholder="https://www.instrumentvideo.com"
                       class="px-2 py-2.5 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                @error('video_link') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> {{ $message }}</span> @enderror
            </div>


        </div>
        <div class="w-full flex justify-end px-4 pb-4 gap-2">
            <button type="submit"
                    class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                <span wire:loading.remove wire:target="submit">
                    <i class="fa fa-{{$isEditing ? 'check' : 'plus'}} mr-2"></i>
                    {{$isEditing ? 'Update Instrument' : 'Create Instrument'}}
                </span>
                <span wire:loading wire:target="submit">
                    {{$isEditing ? 'Updating Instrument...' : 'Creating Instrument...'}} <i class="fas fa-hourglass-half fa-spin ml-2"></i>
                </span>
            </button>
        </div>
    </form>
</div>
