<div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
    <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
        <h3 class="text-lg font-semibold mb-4 text-primary">Add Funds</h3>
        <form wire:submit="submitFunds">
            <div class="w-full flex flex-col gap-4">
                <div class="w-full flex flex-col gap-1">
                    <label class="font-semibold text-primary">Principal Investigator <span class="text-danger">*</span></label>
                    <select wire:model="principal_investigator_id"
                            class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="">---select pi----</option>
                        @foreach($investigators as $investigator)
                            <option value="{{ $investigator->id }}">{{ $investigator->full_name }}</option>
                        @endforeach
                    </select>
                    @error('principal_investigator_id') <span class="text-red-500"><i
                            class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                </div>

                <div class="w-full flex flex-col gap-1">
                    <label class="font-semibold text-primary">Amount <span
                            class="text-danger">*</span></label>
                    <input type="number" wire:model="amount" placeholder="Enter amount"
                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    @error('amount') <span class="text-red-500"><i
                            class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                </div>
            </div>
            <div class="flex justify-end space-x-3 mt-4">
                <button type="button" wire:click="cancel"
                        class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                    Cancel
                </button>
                <button type="submit"
                        class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                    <span wire:loading.remove wire:target="submitFunds">{{$fundId?'Edit Fund':'Add Fund'}}</span>
                    <span wire:loading wire:target="submitFunds">{{$fundId?'Editing':'Adding'}} Funds... <i
                            class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                </button>
            </div>
        </form>
    </div>
</div>
