
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link rel="icon" href="{{ config('app.fav_icon') }}" type="image/x-icon"/>

    <title>BSBE - Login</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    {!! ToastMagic::styles() !!}

</head>
<!-- rest of your HTML code remains the same -->
<body class="flex min-h-screen items-center justify-center p-4 bg-gray-900 bg-opacity-60" style="background: linear-gradient(rgba(0,0,0,0.7), rgba(0,0,0,0.7)), url({{asset('assets/images/loginBg.jpg')}}); background-size: cover; background-position: center; font-family: Roboto">

<div class="w-full max-w-lg bg-gray-300 border-2 border-gray-400 px-6 py-10 rounded-lg shadow-lg">
    <div class="w-full flex justify-center items-center flex-col">
        <img src="{{config('app.logo')}}" class="lg:h-40 md:h-40 sm:h-36 h-32 w-auto" alt="{{config('app.name')}}"/>
    </div>
    <div class="mt-4 flex flex-col items-center text-center">
        <span class="lg:text-[30px] md:text-[38px] sm:text-[25px] text-[25px] font-semibold text-primary">{{config('app.name')}}</span>
        <span class="lg:text-[16px] md:text-[16px] sm:text-[14px] text-[12px] font-semibold text-primary">{{config('app.description')}}</span>
        <div class="w-[90%]">
            <p class="lg:text-xs md:text-xs sm:text-xs text-[10px] text-gray-900">Powered by <strong>{{config('app.developed_by')}}</strong></p>
        </div>
    </div>
    <div class="mt-8">
            {{ $slot }}
    </div>
</div>
{!! ToastMagic::scripts() !!}
</body>
</html>

