<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{config('app.name')}}- Admin Dashboard</title>
    <link rel="icon" type="image/x-icon" href="{{config('app.fav_icon')}}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,100..900;1,100..900&display=swap"
          rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
          integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    {!! ToastMagic::styles() !!}

    @wirechatStyles
    <style>
        ::-webkit-scrollbar {
            width: 2px;
            height: 2px;
        }

        /* Track */
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        /* Handle */
        ::-webkit-scrollbar-thumb {
            background: #001A6E;
        }

        /* Handle on hover */
        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }


        /*input[type="date"]::-webkit-datetime-edit {*/
        /*    color: #172432b3; !* Change placeholder text color *!*/
        /*}*/

        /*input[type="date"]::-webkit-calendar-picker-indicator {*/
        /*    opacity: 0;*/
        /*}*/


        select {
            -webkit-appearance: none !important; /* Hides the arrow in WebKit-based browsers (Chrome, Safari, Edge) */
            -moz-appearance: none !important; /* Hides the arrow in Firefox */
            appearance: none !important; /* Standard property */
            background: white !important;
            color: rgba(0, 0, 0, 0.7) !important; /* Removes background if needed */
        }

        select option {
            color: rgba(14, 14, 14, 0.9) !important; /* Match placeholder text */
            background-color: #ffffff !important;
        }
    </style>
</head>
<body class="bg-gray-100 relative" style="font-family: 'Public Sans', serif; height: 100vh; width: 100%; overflow:hidden">
<div id="sideBarOverlay" class="xl:w-0 lg:w-0  h-full bg-black/40 absolute top-0 left-0 z-40"
     onclick="document.getElementById('sideBarDiv').classList.toggle('hidden'); document.getElementById('sideBarDiv').classList.toggle('flex'); document.getElementById('sideBarOverlay').classList.toggle('w-full');"></div>

<div class="flex w-full ">
    <div id="sideBarDiv" class="z-20 w-72 p-4 h-[100vh] bg-primary overflow-x-hidden overflow-y-auto flex-none xl:static lg:static absolute top-0 left-0 xl:flex  lg:flex flex-col flex hidden z-50">
        <div class="w-full flex flex-none flex-col justify-center items-center border-b-[1px] pb-2 border-b-gray-100/20 shadow-lg shadow-gray-700/10">
            @if(auth()->user()->hasRole('super_admin'))
                <img src="{{config('app.dark_logo')}}" class="h-40 w-40 rounded-full object-cover"
                     alt="{{auth()->user()->name}}">

            @elseif(auth()->user()->hasRole('pi'))
                <img src="{{ auth()->user()->principalInvestigators->first()->profile_photo
                ? asset('storage/' . auth()->user()->principalInvestigators->first()->profile_photo)
                : config('app.dark_logo') }}"
                     class="h-40 w-40 rounded-full object-cover"
                     alt="{{ auth()->user()->name }}">
            @elseif(auth()->user()->hasRole('technician'))
                <img src="{{ auth()->user()->technicians->first()->profile_photo
                ? asset('storage/' . auth()->user()->technicians->first()->profile_photo)
                : config('app.dark_logo') }}"
                     class="h-40 w-40 rounded-full object-cover"
                     alt="{{ auth()->user()->name }}">
            @else
                <img src="{{ auth()->user()->students->first()->profile_photo
                ? asset('storage/' . auth()->user()->students->first()->profile_photo)
                : config('app.dark_logo') }}"
                     class="h-40 w-40 rounded-full object-cover"
                     alt="{{ auth()->user()->name }}">

            @endif


            <span class="font-semibold text-white/80 mt-2 text-2xl">{{auth()->user()->name}}</span>
            <p class="text-primaryLight text-xs text-center"><i class="fa-solid fa-envelope mr-1"></i>
                {{auth()->user()->email}}
            </p>
        </div>

        <div class="w-full flex h-full  flex-col justify-between mt-12 gap-3">
            <div class="flex flex-col gap-3">
                @if(auth()->user()->hasRole('super_admin'))
                    <a href="{{route('dashboard')}}">
                        <div
                            class=" {{Route::currentRouteName()==='dashboard'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-tv mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Dashboard</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endif

                @can ('create pi')
                    <a href="{{route('pi.list')}}">
                        <div
                            class=" {{Route::currentRouteName()==='pi.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Faculty In-Charge</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan

                @can ('create pi')
                    <a href="{{route('technician.list')}}">
                        <div
                            class=" {{Route::currentRouteName()==='technician.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user-gear mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Lab In-Charge</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can ('create lab')
                    <a href="{{route('lab.list')}}">
                        <div
                            class=" {{Route::currentRouteName()==='lab.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa-solid fa-flask mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Labs</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can ('create student')
                    <a href="{{route('student.list')}}">
                        <div
                            class=" {{Route::currentRouteName()==='student.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user-graduate mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Students</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can ('create instrumentCategory')
                    <a href="{{route('instrument.instrument-category')}}">
                        <div
                            class=" {{Route::currentRouteName()==='instrument.instrument-category'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-layer-group mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Instrument Category</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can ('view instrument')
                    <a href="{{route('instrument.instrument')}}">
                        <div
                            class=" {{Route::currentRouteName()==='instrument.instrument'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-microscope mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Instruments</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can('view bookings')
                    <a href="{{route('bookings.create')}}">
                        <div
                            class=" {{Route::currentRouteName()==='bookings.create'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-calendar-days mr-2 text-sm"></i>
                                <span class="text-lg font-medium">
                                 @if(!auth()->user()->hasRole('student'))
                                        Bookings
                                    @else
                                        My Bookings
                                    @endif
                            </span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can('view pending bookings')
                    <a href="{{route('bookings.pendingBookings')}}">
                        <div
                            class=" {{Route::currentRouteName()==='bookings.pendingBookings'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-hourglass-half mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Bookings For Approval </span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                <a href="{{route('usage.index')}}">
                    <div
                        class=" {{Route::currentRouteName()==='usage.index'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                        <div class="flex items-center">
                            <i class="fa fa-chart-bar mr-2 text-sm"></i>
                            <span class="text-lg font-medium">Usage</span>
                        </div>
                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                    </div>
                </a>
            </div>
            <div class="flex flex-col gap-3">
                <a href="{{route('instrument.other-complaints')}}">
                    <div
                        class=" {{Route::currentRouteName()==='instrument.other-complaints'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                        <div class="flex items-center">
                            <i class="fa fa-exclamation-triangle mr-2 text-sm"></i>
                            <span class="text-lg font-medium">Instrument Complaints</span>
                        </div>
                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                    </div>
                </a>
                <span class="text-white text-xs">Account Settings</span>
                @can('create roles')
                    <a href="{{route('rolesPermissions.create')}}">
                        <div
                            class=" {{Route::currentRouteName()==='rolesPermissions.create'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-lock mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Roles & Permissions</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                @can('account settings')
                    <a href="{{route('account.settings')}}">
                        <div
                            class=" {{Route::currentRouteName()==='account.settings'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user-shield mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Admin Settings</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                @endcan
                <div onclick="document.getElementById('passwordUpdateDiv').classList.toggle('hidden')"  class="cursor-pointer border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10 w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                    <div class="flex items-center">
                        <i class="fa fa-lock-open mr-2 text-sm"></i>
                        <span class="text-lg font-medium">Update Password</span>
                    </div>
                    <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                </div>
            </div>
                {{--            @can('view instrument complaint')--}}
                {{--                <a href="{{route('instrument.complaints')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='instrument.complaints'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-exclamation-triangle mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Instrument Complaint</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--            @endcan--}}
                {{--            @can('view instrument services')--}}
                {{--            <a href="{{route('instrument.service')}}">--}}
                {{--                <div--}}
                {{--                    class=" {{Route::currentRouteName()==='instrument.service'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                    <div class="flex items-center">--}}
                {{--                        <i class="fa fa-hammer mr-2 text-sm"></i>--}}
                {{--                        <span class="text-lg font-medium">Instrument Services</span>--}}
                {{--                    </div>--}}
                {{--                    <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                </div>--}}
                {{--            </a>--}}
                {{--          @endcan--}}

                {{--            @can('add funds')--}}
                {{--            <a href="{{route('funds.create')}}">--}}
                {{--                <div--}}
                {{--                    class=" {{Route::currentRouteName()==='funds.create'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                    <div class="flex items-center">--}}
                {{--                        <i class="fa fa-indian-rupee-sign mr-2 text-sm"></i>--}}
                {{--                        <span class="text-lg font-medium">PI Funds</span>--}}
                {{--                    </div>--}}
                {{--                    <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                </div>--}}
                {{--            </a>--}}
                {{--          @endcan--}}
                {{--                @canany(['create storage','view item slots'])--}}

                {{--                <span class="text-white text-xs">Inventory</span>--}}
                {{--                @endcanany--}}
                {{--                @can('create storage')--}}
                {{--                <a href="{{route('inventory.storage')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.storage'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-database mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Storage </span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}
                {{--                @can('view item slots')--}}
                {{--                    @if(auth()->user()->hasRole('student'))--}}
                {{--                    <a href="{{route('inventory.items-slots',['user_id'=>auth()->user()->id])}}">--}}
                {{--                        <div--}}
                {{--                            class=" {{Route::currentRouteName()==='inventory.items-slots'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                            <div class="flex items-center">--}}
                {{--                                <i class="fa fa-database mr-2 text-sm"></i>--}}
                {{--                                <span class="text-lg font-medium">Item Slots </span>--}}
                {{--                            </div>--}}
                {{--                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                        </div>--}}
                {{--                    </a>--}}
                {{--                    @endif--}}
                {{--                @endcan--}}

                {{--                @can('create storage')--}}
                {{--                <a href="{{route('inventory.consumables')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.consumables'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-parachute-box mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Consumables </span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}
                {{--                @can('create storage')--}}
                {{--                <a href="{{route('inventory.bioBank')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.bioBank'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-biohazard mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Bio Bank</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}
                {{--                @canany(['view lab dashboard', 'manage lab categories', 'manage lab items', 'manage lab suppliers', 'manage lab stock', 'manage lab stock alerts', 'manage lab stock reports'])--}}
                {{--                    <span class="text-white text-xs mt-4">Lab Inventory</span>--}}
                {{--                @endcanany--}}
                {{--                @can('view lab dashboard')--}}
                {{--                <a href="{{route('inventory.lab-dashboard')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.lab-dashboard'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-chart-line mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Lab Dashboard</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('manage lab categories')--}}
                {{--                <a href="{{route('inventory.categories')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.categories'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-tags mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Categories</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('manage lab items')--}}
                {{--                <a href="{{route('inventory.items')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.items'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-flask mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Items</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('manage lab suppliers')--}}
                {{--                <a href="{{route('inventory.suppliers')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.suppliers'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-truck mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Suppliers</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('manage lab stock')--}}
                {{--                <a href="{{route('inventory.stock')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.stock'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-boxes mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Stock Management</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('manage lab stock alerts')--}}
                {{--                <a href="{{route('inventory.alerts')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.alerts'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-bell mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Alerts</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('manage lab stock reports')--}}
                {{--                <a href="{{route('inventory.reports')}}">--}}
                {{--                    <div--}}
                {{--                        class=" {{Route::currentRouteName()==='inventory.reports'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                        <div class="flex items-center">--}}
                {{--                            <i class="fa fa-file mr-2 text-sm"></i>--}}
                {{--                            <span class="text-lg font-medium">Reports</span>--}}
                {{--                        </div>--}}
                {{--                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                    </div>--}}
                {{--                </a>--}}
                {{--                @endcan--}}

                {{--                @can('chat conversation')--}}
                {{--                   <span class="text-white text-xs">Conversations</span>--}}
                {{--                    <a href="{{route('chats')}}">--}}
                {{--                        <div--}}
                {{--                            class=" {{Route::currentRouteName()==='chats'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'}} w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">--}}
                {{--                            <div class="flex items-center">--}}
                {{--                                <i class="fa fa-message mr-2 text-sm"></i>--}}
                {{--                                <span class="text-lg font-medium">Chats</span>--}}
                {{--                            </div>--}}
                {{--                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>--}}
                {{--                        </div>--}}
                {{--                    </a>--}}
                {{--                @endcan--}}
        </div>
        <div class="hidden" id="passwordUpdateDiv">
            <livewire:accounts.update-password/>
        </div>
    </div>
    <div class=" h-[100vh] w-full overflow-y-auto">
        <div
            class="w-full px-4 py-2 flex xl:justify-between lg:justify-between md:justify-between sm:justify-between justify-between items-center bg-white sticky top-0 border-b-[2px] border-b-primary/20 z-20">
            <div class="flex items-center">
                <div class="rounded-full h-10 w-10 xl:hidden lg:hidden flex justify-center items-center text-secondary"
                     onclick="document.getElementById('sideBarDiv').classList.toggle('hidden');
                             document.getElementById('sideBarOverlay').classList.toggle('w-full');"><i
                        class="fa fa-bars text-xl" title="Search......"></i></div>
                <span class="font-bold text-primary text-xl xl:block lg:block md:block sm:block hidden">
                   @if(auth()->user()->hasRole('super_admin'))
                    Super Admin Dashboard
                    @elseif(auth()->user()->hasRole('pi'))
                    Principle Investigator Dashboard
                    @elseif(auth()->user()->hasRole('guest'))
                        Dashboard
                    @elseif(auth()->user()->hasRole('technician'))
                      Technician Dashboard
                    @else
                    Student Dashboard
                    @endif
                </span>

            </div>
            <div class="w-max flex items-center">
                <div class="flex items-center ̥gap-2 mx-4 cursor-pointer relative">
                    @if(auth()->user())
                        <livewire:pages.auth.logout/>
                    @endif

                </div>
            </div>
        </div>

        <div class="p-4 w-full relative pb-12" style="min-height: 90vh">
            {{ $slot }}
        </div>

        <div class="w-full px-4 py-2 flex xl:justify-between lg:justify-between md:justify-between flex-wrap items-center bg-white sticky bottom-0 border-t-[2px] border-b-primary/20">
            <div class="flex items-center gap-2">
                <span class="text-black/70 text-sm font-semibold">
                    &copy; {{date('Y')}}
                </span>
                <span class="text-primary text-sm font-semibold hover:text-danger transition ease-in duration-2000">{{config('app.name')}}</span>
            </div>
            <div>
                <span class="text-black/70 text-sm font-semibold">Developed by:</span>
                <a href="{{config('app.developer_link')}}" target="_blank"
                   class="mt-2 text-primary text-md font-semibold hover:text-danger transition ease-in duration-2000">{{config('app.developed_by')}}</a>
            </div>
        </div>

    </div>
</div>


@if (session()->has('success'))
    <div id="successMessage"
         class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
        {{ session('success') }}
        <div onclick="document.getElementById('successMessage').classList.add('hidden')"
             class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
            <i class="fa fa-xmark "></i>
        </div>
    </div>
@endif
@if (session()->has('error'))
    <div id="dangerMessage"
         class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
        {{ session('error') }}
        <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
             class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
            <i class="fa fa-xmark "></i>
        </div>
    </div>
@endif
@stack('scripts')
<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<script>

    jQuery(document).on("click", "button", function () {
        setTimeout(function () {
            jQuery(".alert").hide();
        }, 3000);
    });
</script>
<script> document.querySelectorAll('input[type="date"]').forEach(input => {
        input.setAttribute('max', '9999-12-31');
    });</script>
{!! ToastMagic::scripts() !!}
<script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
@wirechatAssets
</body>
</html>

