<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Suppliers Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .contact-info {
            font-size: 9px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>Generated on: {{ $generatedAt }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Contact Person</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Address</th>
                <th>Stock Batches</th>
                <th>Created</th>
            </tr>
        </thead>
        <tbody>
            @forelse($data as $supplier)
                <tr>
                    <td>{{ $supplier->name }}</td>
                    <td>{{ $supplier->contact_person ?? 'N/A' }}</td>
                    <td class="contact-info">{{ $supplier->email ?? 'N/A' }}</td>
                    <td class="contact-info">{{ $supplier->phone ?? 'N/A' }}</td>
                    <td class="contact-info">{{ $supplier->address ?? 'N/A' }}</td>
                    <td>{{ $supplier->stockBatches->count() ?? 0 }}</td>
                    <td>{{ $supplier->created_at->format('Y-m-d') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" style="text-align: center; color: #666;">No suppliers found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Suppliers Report</p>
        <p>Total Suppliers: {{ $data->count() }}</p>
    </div>
</body>
</html>