<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Stock Transactions Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            font-size: 9px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .transaction-in {
            color: #059669;
            font-weight: bold;
        }
        .transaction-out {
            color: #dc2626;
            font-weight: bold;
        }
        .item-type-chemical {
            color: #7c3aed;
        }
        .item-type-regular {
            color: #059669;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>Generated on: {{ $generatedAt }}</p>
        @if(isset($dateFrom) && isset($dateTo))
            <p>Period: {{ $dateFrom }} to {{ $dateTo }}</p>
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Item</th>
                <th>Category</th>
                <th>Type</th>
                <th>Transaction</th>
                <th>Quantity</th>
                <th>Remaining</th>
                <th>Used For</th>
                <th>Conducted By</th>
                <th>Batch</th>
            </tr>
        </thead>
        <tbody>
            @forelse($data as $transaction)
                <tr>
                    <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                    <td>{{ $transaction->inventoryItem->name ?? 'N/A' }}</td>
                    <td>{{ $transaction->inventoryItem->category->name ?? 'N/A' }}</td>
                    <td class="item-type-{{ $transaction->inventoryItem->item_type ?? 'regular' }}">
                        {{ ucfirst($transaction->inventoryItem->item_type ?? 'regular') }}
                    </td>
                    <td class="transaction-{{ $transaction->transaction_type }}">
                        {{ ucfirst($transaction->transaction_type) }}
                    </td>
                    <td>{{ $transaction->quantity }}</td>
                    <td>{{ $transaction->remaining_quantity }}</td>
                    <td>{{ $transaction->used_for ?? 'N/A' }}</td>
                    <td>{{ $transaction->conducted_by }}</td>
                    <td>{{ $transaction->batch->batch_number ?? 'N/A' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="10" style="text-align: center; color: #666;">No transactions found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Stock Transactions Report</p>
        <p>Total Transactions: {{ $data->count() }}</p>
    </div>
</body>
</html>