<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Stock Alerts Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .alert-low-stock {
            color: #dc2626;
            font-weight: bold;
        }
        .alert-expiry {
            color: #f59e0b;
            font-weight: bold;
        }
        .status-resolved {
            color: #059669;
        }
        .status-active {
            color: #dc2626;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>Generated on: {{ $generatedAt }}</p>
        @if(isset($dateFrom) && isset($dateTo))
            <p>Period: {{ $dateFrom }} to {{ $dateTo }}</p>
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th>Item Name</th>
                <th>Category</th>
                <th>Alert Type</th>
                <th>Message</th>
                <th>Status</th>
                <th>Created</th>
                <th>Resolved By</th>
                <th>Resolved At</th>
            </tr>
        </thead>
        <tbody>
            @forelse($data as $alert)
                <tr>
                    <td>{{ $alert->inventoryItem->name ?? 'N/A' }}</td>
                    <td>{{ $alert->inventoryItem->category->name ?? 'N/A' }}</td>
                    <td class="alert-{{ str_replace('_', '-', $alert->alert_type) }}">
                        {{ ucfirst(str_replace('_', ' ', $alert->alert_type)) }}
                    </td>
                    <td>{{ $alert->alert_message }}</td>
                    <td class="status-{{ $alert->resolved ? 'resolved' : 'active' }}">
                        {{ $alert->resolved ? 'Resolved' : 'Active' }}
                    </td>
                    <td>{{ $alert->created_at->format('Y-m-d H:i') }}</td>
                    <td>{{ $alert->resolved_by ?? 'N/A' }}</td>
                    <td>{{ $alert->resolved_at ? $alert->resolved_at->format('Y-m-d H:i') : 'N/A' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" style="text-align: center; color: #666;">No alerts found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Stock Alerts Report</p>
        <p>Total Alerts: {{ $data->count() }}</p>
        <p>Active Alerts: {{ $data->where('resolved', false)->count() }}</p>
        <p>Resolved Alerts: {{ $data->where('resolved', true)->count() }}</p>
    </div>
</body>
</html>