<!DOCTYPE html>
<html>
<head>
    <title>PI Funds Report</title>
    <style>
        body { font-family: Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .date { text-align: right; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Principal Investigator's Funds Report</h2>
    </div>
    <div class="date">
        Generated on: {{ date('d M Y, h:i A') }}
    </div>
    <table>
        <thead>
            <tr>
                <th>Sr. No.</th>
                <th>Principal Investigator</th>
                <th>Amount</th>
                <th>Fund Added On</th>
            </tr>
        </thead>
        <tbody>
            @foreach($funds as $fund)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $fund->principalInvestigator->full_name }}</td>
                    <td>{{ number_format($fund->amount, 2) }}</td>
                    <td>{{ $fund->created_at->format('d M Y, h:i A') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>