<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Items Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .status-active {
            color: #059669;
            font-weight: bold;
        }
        .status-low {
            color: #dc2626;
            font-weight: bold;
        }
        .item-type-chemical {
            color: #7c3aed;
            font-weight: bold;
        }
        .item-type-regular {
            color: #059669;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>Generated on: {{ $generatedAt }}</p>
        @if(isset($dateFrom) && isset($dateTo))
            <p>Period: {{ $dateFrom }} to {{ $dateTo }}</p>
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Category</th>
                <th>Type</th>
                <th>Current Stock</th>
                <th>Min Level</th>
                <th>Status</th>
                <th>Storage</th>
                <th>Hazard Info</th>
            </tr>
        </thead>
        <tbody>
            @forelse($data as $item)
                <tr>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->category->name ?? 'N/A' }}</td>
                    <td class="item-type-{{ $item->item_type }}">
                        {{ ucfirst($item->item_type ?? 'regular') }}
                    </td>
                    <td>{{ $item->getCurrentStock() }}</td>
                    <td>{{ $item->min_stock_level ?? 'N/A' }}</td>
                    <td class="{{ $item->isLowStock() ? 'status-low' : 'status-active' }}">
                        {{ $item->isLowStock() ? 'Low Stock' : 'Normal' }}
                    </td>
                    <td>{{ $item->storage_conditions ?? 'N/A' }}</td>
                    <td>{{ $item->hazard_information ?? 'N/A' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" style="text-align: center; color: #666;">No items found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Items Report</p>
        <p>Total Items: {{ $data->count() }}</p>
    </div>
</body>
</html>