<!DOCTYPE html>
<html>
<head>
    <title>Instrument List</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .status-working {
            color: green;
        }
        .status-faulty {
            color: red;
        }
        .status-under_maintenance {
            color: orange;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Instrument List</h2>
    <p>Generated on: {{ date('Y-m-d H:i:s') }}</p>
</div>

<table>
    <thead>
    <tr>
        <th>Name</th>
        <th>Category</th>
        <th>Lab</th>
        <th>Model Number</th>
        <th>Serial Number</th>
        <th>Per Hour Cost</th>
        <th>Operating Status</th>
        <th>Engineer Name</th>
        <th>Engineer Contact</th>
    </tr>
    </thead>
    <tbody>
    @foreach($instruments as $instrument)
        <tr>
            <td>{{ $instrument->name }}</td>
            <td>{{ $instrument->instrumentCategory ? $instrument->instrumentCategory->title : 'N/A' }}</td>
            <td>{{ $instrument->lab ? $instrument->lab->lab_name : 'N/A' }}</td>
            <td>{{ $instrument->model_number }}</td>
            <td>{{ $instrument->serial_number }}</td>
            <td>{{ $instrument->booking_cost }}</td>
            <td class="status-{{ $instrument->operating_status }}">{{ ucfirst($instrument->operating_status) }}</td>
            <td>{{ $instrument->engineer_name }}</td>
            <td>{{ $instrument->engineer_email }} / {{ $instrument->engineer_mobile }}</td>
        </tr>
    @endforeach
    </tbody>
</table>
</body>
</html>
