<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>New Contact Form Submission</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 150px;
            height: auto;
        }
        .divider {
            height: 3px;
            background: linear-gradient(90deg, #001A6E 0%, #009990 100%);
            margin: 20px 0;
            border: none;
        }
        .content-box {
            background-color: #f9f9f9;
            border-left: 4px solid #001A6E;
            padding: 15px;
            margin: 15px 0;
        }
        .label {
            font-weight: bold;
            color: #001A6E;
            display: inline-block;
            width: 80px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666666;
        }
        .button {
            background-color: #009990;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class="header">
        <!-- Replace with your actual logo -->
        <img src="https://kinkarlab.com/assets/images/logo.png" alt="Company Logo" class="logo">
        <h1 style="color: #001A6E;">New Contact Inquiry</h1>
    </div>

    <hr class="divider">

    <div class="content-box">
        <p><span class="label">Name:</span> <span style="color: black">{{ $data['name'] }}</span></p>
        <p><span class="label">Email:</span> <span style="color: black"> {{ $data['email'] }}</span></p>
        <p><span class="label">Phone:</span> <span style="color: black"> {{ $data['phone'] }}</span></p>
        <p><span class="label">Subject:</span> <span style="color: black"> {{ $data['subject'] }}</span></p>
    </div>

    <h3 style="color: #001A6E;">Message:</h3>
    <p style=" background-color: #f5f5f5; padding: 15px; border-radius: 4px;">
        {{ $data['message'] }}
    </p>

    <div style="text-align: center; margin: 25px 0;">
        <a href="mailto:{{ $data['email'] }}" class="button">Reply to {{ $data['name'] }}</a>
    </div>

    <hr class="divider">

    <div class="footer">
        <p style="color: black">This message was sent from the contact form at {{ config('app.name') }}</p>
        <p style="color: black">© <?php echo date("Y"); ?> {{ config('app.name') }}. All rights reserved.</p>
    </div>
</body>
</html>
