<!DOCTYPE html>
<html>
<head>
    <title>Quotation Details</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .header { text-align: center; margin-bottom: 30px; }
        .company-logo { max-width: 200px; margin-bottom: 15px; }
        .quotation-info { margin-bottom: 20px; }
        .customer-info { margin-bottom: 30px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f5f5f5; }
        .total-section { text-align: right; margin-top: 20px; }
        .footer { margin-top: 50px; text-align: center; font-size: 0.9em; color: #666; }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ asset('assets/images/logo.png') }}" alt="Company Logo" class="company-logo">
        <h2>{{ config('app.name') }}</h2>
        <p>Your Trusted Research Partner</p>
    </div>

    <div class="quotation-info">
        <h3>Quotation</h3>
        <p>Date: {{ date('d/m/Y') }}</p>
        <p>Quotation No: QT-{{ time() }}</p>
    </div>

    <div class="customer-info">
        <h4>Customer Details:</h4>
        <p>Name: {{ $customerName }}</p>
        <p>Organization: {{ $organization }}</p>
        <p>Email: {{ $email }}</p>
        <p>Phone: {{ $phone }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Sr No.</th>
                <th>Instrument Name</th>
                <th>Type</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>GST</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($instruments as $index => $instrument)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $instrument['name'] }}</td>
                    <td>{{ $instrument['type'] }}</td>
                    <td>{{ $instrument['quantity'] }}</td>
                    <td>₹{{ $instrument['rate'] }}</td>
                    <td>{{ $instrument['gst'] }}%</td>
                    <td>₹{{ $instrument['amount'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="total-section">
        <p><strong>Instrument Charges:</strong> ₹{{ $charges['instrument'] }}</p>
        <p><strong>GST Amount:</strong> ₹{{ $charges['gst'] }}</p>
        <p><strong>Total Amount:</strong> ₹{{ $charges['total'] }}</p>
    </div>

    <div class="footer">
        <p>Thank you for your interest in our services.</p>
        <p>For any queries, please contact us at {{ config('mail.from.address') }}</p>
    </div>
</body>
</html>