<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create PI-related permissions
        $permissions = [
            'view pi',
            'edit pi',
            'create pi',
            'delete pi',

            'edit lab',
            'create lab',
            'delete lab',

            'view student',
            'edit student',
            'create student',
            'delete student',

            'view instrumentCategory',
            'edit instrumentCategory',
            'create instrumentCategory',
            'delete instrumentCategory',

            'view instrument',
            'edit instrument',
            'create instrument',
            'delete instrument',

            'create bookings',
            'view bookings',
            'delete bookings',
            'view pending bookings',

            'create instrument complaint',
            'view instrument complaint',
            'update instrument complaint',

            'raise instrument service request',
            'view instrument service request',
            'update instrument service request',

            'create roles',
            'view roles',
            'delete roles',
            'assign permissions',

            'add funds',

            'view instrument services',

            'account settings',

            'create storage',
            'view storage',
            'delete storage',
            'edit storage',

            'create item slots',
            'view item slots',
            'delete item slots',
            'edit item slots',

            'view lab dashboard',
            'manage lab categories',
            'manage lab items',
            'manage lab suppliers',
            'manage lab stock',
            'manage lab stock alerts',
            'manage lab stock reports',


            'chat conversation',
        ];

//        foreach ($permissions as $permission) {
//            Permission::create(['name' => $permission]);
//        }

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission],
                ['guard_name' => 'web']
            );
        }


        // Get roles
        $superAdminRole = Role::findByName('super_admin');
        $piRole = Role::findByName('pi');
        $studentRole = Role::findByName('student');
        $guestRole = Role::findByName('guest');
        $technicianRole = Role::findByName('technician');

        // Assign permissions to super_admin role
        $superAdminRole->givePermissionTo($permissions);

        // Assign permissions to pi role
        $piRole->givePermissionTo(
            [ 'view pi',
              'edit pi',
                'edit lab',
                'create lab',
                'delete lab',
                'view student',
                'edit student',
                'create student',
                'delete student',
                'view instrumentCategory',
                'edit instrumentCategory',
                'create instrumentCategory',
                'delete instrumentCategory',
                'view instrument',
                'edit instrument',
                'create instrument',
                'delete instrument',
                'create bookings',
                'view bookings',
                'delete bookings',
                'create instrument complaint',
                'view instrument complaint',
                'update instrument complaint',
                'view instrument services',
                'create storage',
                'view storage',
                'delete storage',
                'edit storage',
                'create item slots',
                'view item slots',
                'delete item slots',
                'edit item slots',

            ]
        );

        // Assign permissions to technician role
        $technicianRole->givePermissionTo(
            [
                'view instrument',
                'edit instrument',
                'create instrument',
                'view bookings',
                'delete bookings',
                'create instrument complaint',
                'view instrument complaint',
                'update instrument complaint',
                'view instrument services'
            ]
        );

        // Assign view permission to student role
        $studentRole->givePermissionTo(
            [
                'view bookings',
                'create bookings',
                'delete bookings',
                'view instrument',
                'create instrument complaint',
                'view instrument complaint',
            ]
        );

        // Assign view permission to guest role
        $guestRole->givePermissionTo(
            [
                'view bookings',
                'create bookings',
                'view instrument',
                'create instrument complaint',
                'view instrument complaint',
            ]
        );
    }
}
