<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use App\Models\User;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Disable foreign keys (optional for SQLite)
        if (config('database.default') === 'sqlite') {
            DB::statement('PRAGMA foreign_keys=OFF;');
        }

        // Seed basic reference data
        $this->call([
            TitleSeeder::class,
            DepartmentSeeder::class,
            DesignationSeeder::class,
            QualificationSeeder::class,
        ]);

        // ✅ Create roles only if they don't exist
        $roles = ['super_admin', 'pi', 'student', 'guest', 'technician'];
        foreach ($roles as $role) {
            Role::firstOrCreate(['name' => $role, 'guard_name' => 'web']);
        }

        // Run Permission Seeder
        $this->call(PermissionSeeder::class);

        // ✅ Create Super Admin User only if not exists
        $user = User::firstOrCreate(
            ['email' => 'admin@admin.com'],
            ['name' => 'Super Admin', 'password' => bcrypt('password')] // change password later
        );

        // ✅ Assign role only if not already assigned
        if (!$user->hasRole('super_admin')) {
            $user->assignRole('super_admin');
        }

        // ✅ Insert slot data only if table is empty
        if (DB::table('slots')->count() === 0) {
            $startTime = strtotime('09:00');
            $endTime = strtotime('24:00');
            $interval = 30 * 60;

            $slots = [];
            while ($startTime < $endTime) {
                $nextTime = $startTime + $interval;
                $slots[] = [
                    'start_time' => date('H:i', $startTime),
                    'end_time' => date('H:i', $nextTime),
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
                $startTime = $nextTime;
            }

            DB::table('slots')->insert($slots);
        }

        if (config('database.default') === 'sqlite') {
            DB::statement('PRAGMA foreign_keys=ON;');
        }
    }
}
