<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('instrument_accessories', function (Blueprint $table) {
            $table->string('name')->nullable()->change();
            $table->string('model_number')->nullable()->change();
            $table->string('purchase_date')->nullable()->change();
            $table->string('price')->nullable()->change();
            $table->longText('description')->nullable()->change();
            $table->string('status')->nullable()->change();
            $table->string('photo')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('instrument_accessories', function (Blueprint $table) {
            $table->string('name')->nullable(false)->change();
            $table->string('model_number')->nullable(false)->change();
            $table->string('purchase_date')->nullable(false)->change();
            $table->string('price')->nullable(false)->change();
            $table->longText('description')->nullable(false)->change();
            $table->string('status')->nullable(false)->change();
            $table->string('photo')->nullable(false)->change();
        });
    }
};
