<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('stock_batches', function (Blueprint $table) {
            // Drop the foreign key constraint first
            $table->dropForeign(['inventory_item_id']);
            
            // Modify the column to be nullable
            $table->foreignId('inventory_item_id')->nullable()->change();
            
            // Re-add the foreign key constraint
            $table->foreign('inventory_item_id')->references('id')->on('inventory_items')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('stock_batches', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign(['inventory_item_id']);
            
            // Make the column not nullable again
            $table->foreignId('inventory_item_id')->nullable(false)->change();
            
            // Re-add the foreign key constraint
            $table->foreign('inventory_item_id')->references('id')->on('inventory_items')->onDelete('cascade');
        });
    }
};
