<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('batch_items', function (Blueprint $table) {
            $table->date('manufacture_date')->nullable()->after('notes');
            $table->date('expiry_date')->nullable()->after('manufacture_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('batch_items', function (Blueprint $table) {
            $table->dropColumn(['manufacture_date', 'expiry_date']);
        });
    }
};
