<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->string('booking_type')->default('slot');
            $table->string('booked_by')->default('internal');
            $table->decimal('booking_cost', 10, 2)->default(0);
            $table->integer('sample_quantity')->nullable();
        });
    }

    public function down()
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropColumn(['booking_type', 'booked_by', 'booking_cost', 'sample_quantity']);
        });
    }
};