<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('instruments', function (Blueprint $table) {
            // Drop existing columns
            $table->dropColumn('booking_cost');
            $table->dropColumn('booking_cost_type');
            
            // Add new columns
            $table->string('booking_type')->default('slot'); // slot, sample, both
            $table->json('booking_cost')->nullable(); // Will store nested JSON structure for sector-wise pricing
        });
    }

    public function down()
    {
        Schema::table('instruments', function (Blueprint $table) {
            // Revert changes
            $table->dropColumn('booking_type');
            $table->dropColumn('booking_cost');
            
            // Restore original columns
            $table->integer('booking_cost')->default(0);
            $table->string('booking_cost_type')->default('per_booking');
        });
    }
};