<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('bookings_for_approvals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id');
            $table->foreignId('user_id');
            $table->string('status');
            $table->string('remark')->nullable();
            $table->string('approved_by')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('bookings_for_approvals');
    }
};
