<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('instrument_terms', function (Blueprint $table) {
            $table->id();
            $table->foreignId('instrument_id');
            $table->integer('can_cancel_before_booking_slot')->nullable();
            $table->boolean('approval_required')->default(0);
            $table->string('approval_from')->nullable();
            $table->longText('sop')->nullable();
            $table->string('maximum_booking_type')->nullable();
            $table->string('maximum_bookings')->nullable();
            $table->string('maximum_booking_for')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('instrument_terms');
    }
};
