<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('instrument_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('instrument_id');
            $table->string('service_type')->default('repair')->comment(' repair, maintenance');
            $table->longText('description')->nullable();
            $table->boolean('service_paid_or_not')->nullable()->default(0);
            $table->string('next_service_date')->nullable();
            $table->json('instrument_details')->nullable()->comment(' Contains a array of part_name,part_description, part_images[],oldPartReceived');
            $table->json('invoice_details')->nullable()->comment(' Contains a array of invoice_cost, invoice_date, invoice_image');
            $table->string('status')->default('pending')->comment('pending, completed');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('instrument_services');
    }
};
