<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('instrument_purchase_infos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('instrument_id');
            $table->string('manufacturer_name')->nullable();
            $table->string('manufacturing_date')->nullable();
            $table->string('purchase_date')->nullable();
            $table->string('purchase_order_number')->nullable();
            $table->integer('cost')->nullable();
            $table->string('funding_source')->nullable();
            $table->string('installation_date')->nullable();
            $table->string('next_service_date')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('instrument_purchase_infos');
    }
};
