<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('instruments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('instrument_category_id');
            $table->foreignId('lab_id');
            $table->string('name');
            $table->string('model_number')->nullable();
            $table->string('serial_number')->nullable();
            $table->longText('description')->nullable();
            $table->string('operating_status')->nullable()->default('working');
            $table->string('engineer_name')->nullable();
            $table->string('engineer_email')->nullable();
            $table->string('engineer_mobile')->nullable();
            $table->string('engineer_address')->nullable();
            $table->integer('booking_cost')->default(0);
            $table->string('booking_cost_type')->default('per_booking');
            $table->json('photos')->nullable();
            $table->string('operational_manual')->nullable();
            $table->string('service_manual')->nullable();
            $table->string('video_link')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('instruments');
    }
};
