<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('principal_investigator_id')->nullable();
            $table->string('profile_photo')->nullable();
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('academic_id')->nullable();
            $table->string('department')->nullable();
            $table->string('year_of_study_start')->nullable();
            $table->string('year_of_study_end')->nullable();
            $table->string('email')->unique();
            $table->string('alt_email')->nullable();
            $table->string('mobile_number')->nullable();
            $table->string('research_area')->nullable();
            $table->longText('address')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('students');
    }
};
