<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('labs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('principal_investigator_id')->nullable();
            $table->string('lab_image')->nullable();
            $table->string('lab_name');
            $table->string('department')->nullable();
            $table->string('building')->nullable();
            $table->string('floor')->nullable();
            $table->string('room_number')->nullable();
            $table->string('type')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('working_hours')->nullable();
            $table->string('capacity')->nullable();
            $table->longText('description')->nullable();
            $table->longText('safety_guidelines')->nullable();
            $table->text('notes')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('labs');
    }
};
