<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class StockQuantityRule implements ValidationRule
{
    protected $availableQuantity;
    protected $itemName;

    public function __construct($availableQuantity, $itemName = 'item')
    {
        $this->availableQuantity = $availableQuantity;
        $this->itemName = $itemName;
    }

    /**
     * Run the validation rule.
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if ($value <= 0) {
            $fail('The quantity must be greater than zero.');
            return;
        }

        if ($value > $this->availableQuantity) {
            $fail("Insufficient stock available for {$this->itemName}. Available: {$this->availableQuantity}");
            return;
        }
    }
}