<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Namu\WireChat\Traits\Chatable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, HasRoles, Chatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */

    public function canCreateChats(): bool
    {
        return $this->hasVerifiedEmail();
    }

    public function canCreateGroups(): bool
    {
        return $this->hasVerifiedEmail() === true;
    }

    protected $fillable = [
        'name',
        'email',
        'password',
        'last_password_change',
        'user_type',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function students()
    {
        return $this->hasMany(Student::class);
    }
    public function principalInvestigators()
    {
        return $this->hasMany(PrincipalInvestigator::class);
    }
    public function technicians()
    {
        return $this->hasMany(Technician::class);
    }

    public function bookingForApproval()
    {
        return $this->hasMany(BookingForApproval::class);
    }

    public function itemsSlots()
    {
        return $this->hasMany(ItemsSlot::class);
    }

}
