<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'name', 'contact_person', 'email', 'phone', 'address'
    ];
    
    public function stockBatches()
    {
        return $this->hasMany(StockBatch::class);
    }
    
    public function getFullContactAttribute()
    {
        $contact = $this->name;
        if ($this->contact_person) {
            $contact .= ' (' . $this->contact_person . ')';
        }
        return $contact;
    }
}
