<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SubBox extends Model
{
    protected $fillable = [
        'box_id',
        'sub_box_name',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    public function box(): BelongsTo
    {
        return $this->belongsTo(Boxfield::class, 'box_id');
    }

    public function itemsSlots(): HasMany
    {
        return $this->hasMany(ItemsSlot::class, 'sub_box_id');
    }
}