<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SlotFile extends Model
{
    protected $fillable = [
        'items_slot_id',
        'file_name',
        'file_path',
        'file_type',
        'file_size',
    ];

    public function itemsSlot(): BelongsTo
    {
        return $this->belongsTo(ItemsSlot::class, 'items_slot_id');
    }
}