<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PrincipalInvestigator extends Model
{
    use HasFactory;


    protected $fillable = [
        'user_id',
        'title',
        'first_name',
        'last_name',
        'department',
        'designation',
        'email',
        'alt_email',
        'phone',
        'mobile',
        'office_address',
        'specialization',
        'qualification',
        'profile_photo',
        'status',
        'available_funds',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function students()
    {
        return $this->hasMany(Student::class);
    }

    public function labs()
    {
        return $this->hasOne(Lab::class);
    }

    public function piFund()
    {
        return $this->hasMany(piFund::class);
    }

    public function getFullNameAttribute()
    {
        $title = $this->title ?? '';
        $firstName = $this->first_name ?? '';
        $lastName = $this->last_name ?? '';

        return trim("{$title} {$firstName} {$lastName}");
    }


    public function getAllPiBookings()
    {
        return Booking::whereHas('student', function($query) {
            $query->where('principal_investigator_id', $this->id);
        })
            ->where('status', 'confirmed')
            ->with(['instrument', 'slots', 'student'])
            ->get();
    }


    public function getAllPiFunds()
    {
        return $this->piFund()->sum('amount');
    }

    public function getAllPiFundUtilised()
    {
        return $this->getAllPiBookings()
            ->where('status', 'confirmed')
            ->sum('booking_cost');
    }


}
