<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ItemsSlot extends Model
{
    protected $fillable = [
        'sub_box_id',
        'user_id',
        'items_slot_name',
        'status',
        'items_capacity',
    ];

    protected $casts = [
        'status' => 'boolean',
        'items_capacity' => 'integer',
    ];

    public function subBox(): BelongsTo
    {
        return $this->belongsTo(SubBox::class, 'sub_box_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function items(): HasMany
    {
        return $this->hasMany(Item::class, 'items_slot_id');
    }

    public function slotFiles(): HasMany
    {
        return $this->hasMany(SlotFile::class, 'items_slot_id');
    }

    public function getAvailableCapacityAttribute()
    {
        return $this->items_capacity - $this->items()->count();
    }
}