<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ItemFile extends Model
{
    protected $fillable = [
        'item_id',
        'file_name',
        'file_path',
        'file_type',
        'file_size',
    ];

    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class, 'item_id');
    }
}