<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Item extends Model
{
    protected $fillable = [
        'items_slot_id',
        'item_name',
        'item_info',
        'item_photo',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    public function itemsSlot(): BelongsTo
    {
        return $this->belongsTo(ItemsSlot::class, 'items_slot_id');
    }

    public function itemFiles(): HasMany
    {
        return $this->hasMany(ItemFile::class, 'item_id');
    }
}