<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InventoryItem extends Model
{
    protected $fillable = [
        'category_id', 'name', 'description', 'item_type',
        'min_stock_level', 'storage_conditions', 'hazard_information'
    ];
    
    protected $casts = [
        'item_type' => 'string'
    ];
    
    public function category()
    {
        return $this->belongsTo(Category::class);
    }
    
    public function variants()
    {
        return $this->hasMany(ItemVariant::class, 'inventory_item_id');
    }
    
    public function stockBatches()
    {
        return $this->hasMany(StockBatch::class, 'inventory_item_id');
    }
    
    public function transactions()
    {
        return $this->hasMany(StockTransaction::class, 'inventory_item_id');
    }
    
    public function alerts()
    {
        return $this->hasMany(StockAlert::class, 'inventory_item_id');
    }
    
    public function getCurrentStock()
    {
        // Sum current quantity from all batch items for this inventory item
        return \App\Models\BatchItem::where('inventory_item_id', $this->id)
            ->sum('current_quantity');
    }
    
    public function isLowStock()
    {
        return $this->min_stock_level && $this->getCurrentStock() <= $this->min_stock_level;
    }
    
    public function isOutOfStock()
    {
        return $this->getCurrentStock() <= 0;
    }
    
    public function batchItems()
    {
        return $this->hasMany(\App\Models\BatchItem::class, 'inventory_item_id');
    }
    
    public function isChemical()
    {
        return $this->item_type === 'chemical';
    }
}
